/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.common.rolemap;

import java.security.GeneralSecurityException;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import uk.org.ogsadai.common.Base64;
import uk.org.ogsadai.common.MissingSystemPropertyException;
import uk.org.ogsadai.common.rolemap.CryptographyException;

public class Cryptography {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2005. (c) University of Edinburgh 2002 - 2005.";
    private static final String ALGORITHM = "PBEWithMD5AndDES";
    private static final byte[] SALT = new byte[]{-57, 115, 33, -116, 126, -56, -18, -103};
    private static final int COUNT = 20;
    private static final String PASSWORD = "ogsadai.password";

    public static String getPassword() throws MissingSystemPropertyException {
        String pw = System.getProperty(PASSWORD);
        if (pw == null) {
            throw new MissingSystemPropertyException(PASSWORD);
        }
        return pw;
    }

    public static String scramble(String password, byte[] plainText) throws CryptographyException {
        byte[] cypherText = Cryptography.encrypt(password, plainText);
        byte[] encoded = Cryptography.encode(cypherText);
        return new String(encoded);
    }

    public static String scramble(String password, String plainText) throws CryptographyException {
        return Cryptography.scramble(password, plainText.getBytes());
    }

    public static String unscramble(String password, byte[] scrambled) throws CryptographyException {
        byte[] decoded = Cryptography.decode(scrambled);
        byte[] decrypted = Cryptography.decrypt(password, decoded);
        return new String(decrypted);
    }

    public static String unscramble(String password, String scrambled) throws CryptographyException {
        return Cryptography.unscramble(password, scrambled.getBytes());
    }

    public static String unscramble(String scrambled) throws CryptographyException, MissingSystemPropertyException {
        return Cryptography.unscramble(Cryptography.getPassword(), scrambled);
    }

    private static byte[] encode(byte[] string) {
        return new Base64().encode(string);
    }

    private static byte[] decode(byte[] string) {
        return new Base64().decode(string);
    }

    private static byte[] decrypt(String password, byte[] cypherText) throws CryptographyException {
        try {
            Cipher cypher = Cryptography.getCypher(password, 2);
            return cypher.doFinal(cypherText);
        }
        catch (GeneralSecurityException e) {
            throw new CryptographyException(e);
        }
    }

    private static byte[] decrypt(String password, String cypherText) throws CryptographyException {
        return Cryptography.decrypt(password, cypherText.getBytes());
    }

    private static byte[] encrypt(String password, byte[] plainText) throws CryptographyException {
        try {
            Cipher cypher = Cryptography.getCypher(password, 1);
            return cypher.doFinal(plainText);
        }
        catch (GeneralSecurityException e) {
            throw new CryptographyException(e);
        }
    }

    private static byte[] encrypt(String password, String plainText) throws CryptographyException {
        return Cryptography.encrypt(password, plainText.getBytes());
    }

    private static Cipher getCypher(String password, int encryptMode) throws CryptographyException {
        Cipher cypher = null;
        try {
            PBEParameterSpec params = new PBEParameterSpec(SALT, 20);
            SecretKeyFactory keyFactory = null;
            keyFactory = SecretKeyFactory.getInstance(ALGORITHM);
            char[] pwChars = password.toCharArray();
            PBEKeySpec keySpec = new PBEKeySpec(pwChars);
            SecretKey key = keyFactory.generateSecret(keySpec);
            cypher = Cipher.getInstance(ALGORITHM);
            cypher.init(encryptMode, (Key)key, params);
        }
        catch (GeneralSecurityException e) {
            throw new CryptographyException(e);
        }
        return cypher;
    }
}

