/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.common.properties;

import java.util.Observable;
import java.util.Observer;
import javax.xml.namespace.QName;
import uk.org.ogsadai.common.properties.Property;
import uk.org.ogsadai.common.properties.PropertyValueException;

public class SelfUpdatingProperty
extends Property {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2005. (c) University of Edinburgh 2005";
    private Object mValue;
    private final Observable mObservable;

    public SelfUpdatingProperty(QName name, Object initialValue, Observable observable) {
        this.setName(name);
        this.setValue(initialValue);
        this.mObservable = observable;
        this.mObservable.addObserver(this.createObserver());
    }

    protected Observer createObserver() {
        Observer observer = new Observer(){

            public void update(Observable source, Object argument) {
                SelfUpdatingProperty.this.setValue(argument);
            }
        };
        return observer;
    }

    public Object getValue() throws PropertyValueException {
        return this.mValue;
    }

    public void setValue(Object value) {
        this.mValue = value;
        this.setChanged();
        this.notifyObservers(value);
    }
}

