/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.common.properties;

import java.util.Observable;
import java.util.Observer;
import javax.xml.namespace.QName;
import uk.org.ogsadai.common.properties.Property;
import uk.org.ogsadai.common.properties.PropertyValueException;

public class SelfNotifyingProperty
extends Property {
    private static final String COPYRIGHT_NOTICE = "(c) University of Edinburgh 2005";
    private final Observable mObservableValue;

    public SelfNotifyingProperty(QName name, Observable observableValue) {
        this.setName(name);
        this.mObservableValue = observableValue;
        this.mObservableValue.addObserver(this.createObserver());
    }

    protected Observer createObserver() {
        Observer observer = new Observer(){

            public void update(Observable source, Object argument) {
                SelfNotifyingProperty.this.setChanged();
                SelfNotifyingProperty.this.notifyObservers(SelfNotifyingProperty.this.mObservableValue);
            }
        };
        return observer;
    }

    public Object getValue() throws PropertyValueException {
        return this.mObservableValue;
    }

    public void setValue(Object value) {
        throw new UnsupportedOperationException("setValue");
    }
}

