/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.common.properties;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import uk.org.ogsadai.common.properties.PropertyEvent;
import uk.org.ogsadai.common.properties.PropertyListener;

public class PropertyEventDispatcher
implements PropertyListener {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2005. (c) The University of Edinburgh 2002 - 2005.";
    private final Collection mListeners = new HashSet();

    public synchronized void addPropertyListener(PropertyListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Listener must not be null.");
        }
        this.mListeners.add(listener);
    }

    public synchronized void propertyAdded(PropertyEvent event) {
        if (event == null) {
            throw new IllegalArgumentException("Event must not be null");
        }
        Iterator i = this.mListeners.iterator();
        while (i.hasNext()) {
            PropertyListener listener = (PropertyListener)i.next();
            listener.propertyAdded(event);
        }
    }

    public synchronized void propertyRemoved(PropertyEvent event) {
        if (event == null) {
            throw new IllegalArgumentException("Event must not be null");
        }
        Iterator i = this.mListeners.iterator();
        while (i.hasNext()) {
            PropertyListener listener = (PropertyListener)i.next();
            listener.propertyRemoved(event);
        }
    }

    public synchronized void propertyUpdated(PropertyEvent event) {
        if (event == null) {
            throw new IllegalArgumentException("Event must not be null");
        }
        Iterator i = this.mListeners.iterator();
        while (i.hasNext()) {
            PropertyListener listener = (PropertyListener)i.next();
            listener.propertyUpdated(event);
        }
    }
}

