/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.common.properties;

import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import uk.org.ogsadai.common.msgs.DAILogger;
import uk.org.ogsadai.common.properties.Properties;
import uk.org.ogsadai.common.properties.Property;
import uk.org.ogsadai.common.properties.PropertyEvent;
import uk.org.ogsadai.common.properties.PropertyEventDispatcher;
import uk.org.ogsadai.common.properties.PropertyListener;

public class PropertiesImpl
implements Properties {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2005. (c) University of Edinburgh 2002 - 2005";
    private static DAILogger LOG = DAILogger.getLogger(PropertiesImpl.class);
    private final Map mPropertiesTable = new Hashtable();
    private final PropertyEventDispatcher mDispatcher = new PropertyEventDispatcher();

    public void addPropertyListener(PropertyListener listener) {
        this.mDispatcher.addPropertyListener(listener);
    }

    public Property put(Property property) {
        if (property == null) {
            throw new IllegalArgumentException("Property must not be null");
        }
        QName name = property.getName();
        if (name == null) {
            throw new IllegalArgumentException("Property name must not be null");
        }
        Property oldProperty = this.mPropertiesTable.put(name, property);
        if (oldProperty == null) {
            this.mDispatcher.propertyAdded(new PropertyEvent(this, property));
        } else {
            this.mDispatcher.propertyUpdated(new PropertyEvent(this, property));
        }
        return oldProperty;
    }

    public Object put(Object key, Object value) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Putting property [" + key + "," + value + "]");
        }
        if (!(key instanceof QName)) {
            throw new IllegalArgumentException("Key must be a QName");
        }
        if (!(value instanceof Property)) {
            throw new IllegalArgumentException("Value must be a Property");
        }
        Property property = (Property)value;
        QName name = (QName)key;
        if (property.getName() == null) {
            property.setName(name);
        } else if (!property.getName().equals(name)) {
            throw new IllegalArgumentException("Key does not equal Property name");
        }
        return this.put(property);
    }

    public int size() {
        return this.mPropertiesTable.size();
    }

    public void clear() {
        Iterator i = this.mPropertiesTable.keySet().iterator();
        while (i.hasNext()) {
            QName name = (QName)i.next();
            this.remove(name);
        }
    }

    public boolean isEmpty() {
        return this.mPropertiesTable.isEmpty();
    }

    public boolean containsKey(Object key) {
        return this.mPropertiesTable.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.mPropertiesTable.containsValue(value);
    }

    public Collection values() {
        return this.mPropertiesTable.values();
    }

    public void putAll(Map t) {
        Iterator i = t.keySet().iterator();
        while (i.hasNext()) {
            Object key = i.next();
            Object value = t.get(key);
            this.put(key, value);
        }
    }

    public Set entrySet() {
        return this.mPropertiesTable.entrySet();
    }

    public Set keySet() {
        return this.mPropertiesTable.keySet();
    }

    public Object get(Object key) {
        return this.mPropertiesTable.get(key);
    }

    public Object remove(Object key) {
        Property oldProperty = (Property)this.mPropertiesTable.remove(key);
        if (oldProperty != null) {
            this.mDispatcher.propertyRemoved(new PropertyEvent(this, oldProperty));
        }
        return oldProperty;
    }
}

