/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.common.properties;

import javax.xml.namespace.QName;
import uk.org.ogsadai.common.SecurityContext;
import uk.org.ogsadai.common.properties.DynamicPropertyCreationException;
import uk.org.ogsadai.common.properties.Property;
import uk.org.ogsadai.common.properties.PropertyCallback;
import uk.org.ogsadai.common.properties.PropertyValueException;
import uk.org.ogsadai.exception.DAIClassCreateException;
import uk.org.ogsadai.exception.DAIClassMissingInterfaceException;
import uk.org.ogsadai.exception.DAIClassNotFoundException;

public class DynamicProperty
extends Property {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2005. (c) University of Edinburgh 2005";
    protected PropertyCallback mPropertyCallback = null;

    public PropertyCallback getCallback() {
        return this.mPropertyCallback;
    }

    public void setCallback(PropertyCallback callback) {
        this.mPropertyCallback = callback;
    }

    public Object getValue() throws PropertyValueException {
        if (this.mPropertyCallback == null) {
            return null;
        }
        return this.mPropertyCallback.getValue(this.mName);
    }

    public void setValue(Object object) throws PropertyValueException {
        if (this.mPropertyCallback != null) {
            this.mPropertyCallback.setValue(this.mName, object);
        }
    }

    public void setSecurityContext(SecurityContext sec) {
        super.setSecurityContext(sec);
        if (this.mPropertyCallback != null) {
            this.mPropertyCallback.setSecurityContext(sec);
        }
    }

    public static DynamicProperty createDynamicProperty(QName name, String callback) throws DynamicPropertyCreationException {
        try {
            DynamicProperty property = new DynamicProperty();
            property.setName(name);
            Class<?> callbackClass = Class.forName(callback);
            PropertyCallback propertyCallback = (PropertyCallback)callbackClass.newInstance();
            property.setCallback(propertyCallback);
            return property;
        }
        catch (ClassNotFoundException e) {
            throw new DynamicPropertyCreationException(name, new DAIClassNotFoundException(callback));
        }
        catch (InstantiationException e) {
            throw new DynamicPropertyCreationException(name, new DAIClassCreateException(callback, e));
        }
        catch (IllegalAccessException e) {
            throw new DynamicPropertyCreationException(name, new DAIClassCreateException(callback, e));
        }
        catch (ClassCastException e) {
            throw new DynamicPropertyCreationException(name, new DAIClassMissingInterfaceException(callback, PropertyCallback.class.getName()));
        }
    }
}

