/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.common.msgs;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import uk.org.ogsadai.common.msgs.DAILogger;
import uk.org.ogsadai.common.msgs.DAIResourceBundle;
import uk.org.ogsadai.common.msgs.DAIUniqueID;
import uk.org.ogsadai.common.msgs.MessageID;
import uk.org.ogsadai.exception.ErrorID;

public class MessageLoader {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2006. (c) University of Edinburgh 2002 - 2006.";
    private static DAILogger LOG = DAILogger.getLogger(MessageLoader.class);
    private static DAIResourceBundle mBundle = null;

    private MessageLoader() {
    }

    private static String getString(String key) {
        String result = null;
        if (mBundle != null) {
            try {
                result = mBundle.getString(key);
            }
            catch (MissingResourceException e) {
                LOG.warn(ErrorID.MISSING_MESSAGE_ERROR, new Object[]{e.getKey()});
            }
        }
        return result;
    }

    private static String getLocalizedMessage(String key) {
        String message = MessageLoader.getString(key);
        if (message == null) {
            message = MessageLoader.getMessage(key);
        }
        return message;
    }

    private static String getLocalizedMessage(String key, DAIUniqueID uniqueID) {
        String message = MessageLoader.getString(key);
        if (message == null) {
            message = MessageLoader.getMessage(key, uniqueID);
        }
        return message;
    }

    private static String getLocalizedMessage(String key, Object[] parameters) {
        String result;
        String message = MessageLoader.getString(key);
        if (message != null) {
            MessageFormat formatter = new MessageFormat(message);
            formatter.setLocale(Locale.getDefault());
            result = formatter.format(parameters);
        } else {
            result = MessageLoader.getMessage(key, parameters);
        }
        return result;
    }

    private static String getLocalizedMessage(String key, Object[] parameters, DAIUniqueID uniqueID) {
        String result;
        String message = MessageLoader.getString(key);
        if (message != null) {
            MessageFormat formatter = new MessageFormat(message);
            formatter.setLocale(Locale.getDefault());
            result = formatter.format(parameters);
        } else {
            result = MessageLoader.getMessage(key, parameters, uniqueID);
        }
        return result;
    }

    private static String getMessage(String key) {
        return key;
    }

    private static String getMessage(String key, DAIUniqueID uniqueID) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[");
        buffer.append(uniqueID);
        buffer.append("] ");
        buffer.append(key);
        return buffer.toString();
    }

    private static String getMessage(String key, Object[] parameters) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(key);
        int numParameters = parameters.length;
        for (int i = 0; i < numParameters; ++i) {
            buffer.append(i == 0 ? " : " : ", ");
            buffer.append(parameters[i]);
        }
        return buffer.toString();
    }

    private static String getMessage(String key, Object[] parameters, DAIUniqueID uniqueID) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[");
        buffer.append(uniqueID);
        buffer.append("] ");
        buffer.append(key);
        int numParameters = parameters.length;
        for (int i = 0; i < numParameters; ++i) {
            buffer.append(i == 0 ? " : " : ", ");
            buffer.append(parameters[i]);
        }
        return buffer.toString();
    }

    public static String getLocalizedMessage(MessageID key) {
        return MessageLoader.getLocalizedMessage(key.toString());
    }

    public static String getLocalizedMessage(MessageID key, DAIUniqueID uniqueID) {
        return MessageLoader.getLocalizedMessage(key.toString(), uniqueID);
    }

    public static String getLocalizedMessage(MessageID key, Object[] parameters) {
        return MessageLoader.getLocalizedMessage(key.toString(), parameters);
    }

    public static String getLocalizedMessage(MessageID key, Object[] parameters, DAIUniqueID uniqueID) {
        return MessageLoader.getLocalizedMessage(key.toString(), parameters, uniqueID);
    }

    public static String getMessage(MessageID key) {
        return MessageLoader.getMessage(key.toString());
    }

    public static String getMessage(MessageID key, DAIUniqueID uniqueID) {
        return MessageLoader.getMessage(key.toString(), uniqueID);
    }

    public static String getMessage(MessageID key, Object[] parameters) {
        return MessageLoader.getMessage(key.toString(), parameters);
    }

    public static String getMessage(MessageID key, Object[] parameters, DAIUniqueID uniqueID) {
        return MessageLoader.getMessage(key.toString(), parameters, uniqueID);
    }

    public static void registerMessageBundle(String baseName, Locale locale) {
        try {
            if (baseName != null) {
                mBundle.registerResourceBundle(baseName, locale);
            }
        }
        catch (MissingResourceException e) {
            LOG.warn(ErrorID.MISSING_MESSAGE_BUNDLE_ERROR, new Object[]{e.getKey()});
        }
    }

    static {
        try {
            mBundle = new DAIResourceBundle();
        }
        catch (MissingResourceException e) {
            LOG.warn(ErrorID.MISSING_MESSAGE_BUNDLE_ERROR, new Object[]{e.getKey()});
        }
    }
}

