/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.common.msgs;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.log4j.Logger;
import uk.org.ogsadai.common.msgs.DAIUniqueID;
import uk.org.ogsadai.common.msgs.MessageID;
import uk.org.ogsadai.common.msgs.MessageLoader;
import uk.org.ogsadai.exception.DAIExceptionInformation;
import uk.org.ogsadai.exception.ErrorID;

public class DAILogger {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2005. (c) University of Edinburgh 2002 - 2005";
    private Class mClass;
    private Logger mLogger;
    private boolean debugEnabled;

    public static DAILogger getLogger(Class theClass) {
        return new DAILogger(theClass);
    }

    private DAILogger(Class theClass) {
        this.mLogger = Logger.getLogger((Class)theClass);
        this.mClass = theClass;
        this.debugEnabled = this.mLogger.isDebugEnabled();
    }

    public void debug(String message) {
        this.mLogger.debug((Object)message);
    }

    public void debug(DAIUniqueID id, String message) {
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)this.addIDToMessage(id, message));
        }
    }

    public boolean isDebugEnabled() {
        return this.debugEnabled;
    }

    public void info(MessageID messageID) {
        this.info(messageID, new Object[0]);
    }

    public void info(MessageID messageID, Object parameter) {
        this.info(messageID, new Object[]{parameter});
    }

    public void info(MessageID messageID, Object[] parameters) {
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)this.getLocalizedMessage(messageID, parameters));
        }
    }

    public boolean isInfoEnabled() {
        return this.mLogger.isInfoEnabled();
    }

    public void warn(Throwable exception) {
        this.warnExceptionAndChildren(exception, false);
    }

    public void warn(Throwable exception, boolean stackTrace) {
        this.warnExceptionAndChildren(exception, stackTrace);
    }

    public void error(Throwable exception) {
        this.errorExceptionAndChildren(exception, false);
    }

    public void error(Throwable exception, boolean stackTrace) {
        this.errorExceptionAndChildren(exception, stackTrace);
    }

    void warn(ErrorID errorID, Object[] parameters) {
        this.mLogger.warn((Object)MessageLoader.getMessage((MessageID)errorID, parameters));
    }

    public void fatal(Throwable exception) {
        this.fatalExceptionAndChildren(exception, false);
    }

    public void fatal(Throwable exception, boolean stackTrace) {
        this.fatalExceptionAndChildren(exception, stackTrace);
    }

    private void warnExceptionAndChildren(Throwable e, boolean stackTrace) {
        DAIUniqueID batchID = e instanceof DAIExceptionInformation ? ((DAIExceptionInformation)((Object)e)).getExceptionID() : DAIUniqueID.newInstance();
        for (Throwable ex = e; ex != null; ex = ex.getCause()) {
            String message = "";
            if (ex instanceof DAIExceptionInformation) {
                DAIExceptionInformation daix = (DAIExceptionInformation)((Object)ex);
                message = this.getLocalizedMessage(batchID, daix.getErrorID(), daix.getParameters());
            } else {
                message = this.addIDToMessage(batchID, ex.getLocalizedMessage());
            }
            this.mLogger.warn((Object)message);
        }
        if (stackTrace) {
            this.logStackTraceWarn(e);
        }
    }

    private void errorExceptionAndChildren(Throwable e, boolean stackTrace) {
        DAIUniqueID batchID = e instanceof DAIExceptionInformation ? ((DAIExceptionInformation)((Object)e)).getExceptionID() : DAIUniqueID.newInstance();
        for (Throwable ex = e; ex != null; ex = ex.getCause()) {
            String message = "";
            if (ex instanceof DAIExceptionInformation) {
                DAIExceptionInformation daix = (DAIExceptionInformation)((Object)ex);
                message = this.getLocalizedMessage(batchID, daix.getErrorID(), daix.getParameters());
            } else {
                message = this.addIDToMessage(batchID, ex.getLocalizedMessage());
            }
            this.mLogger.error((Object)message);
        }
        if (stackTrace) {
            this.logStackTraceError(e);
        }
    }

    private void fatalExceptionAndChildren(Throwable e, boolean stackTrace) {
        DAIUniqueID batchID = e instanceof DAIExceptionInformation ? ((DAIExceptionInformation)((Object)e)).getExceptionID() : DAIUniqueID.newInstance();
        for (Throwable ex = e; ex != null; ex = ex.getCause()) {
            String message = "";
            if (ex instanceof DAIExceptionInformation) {
                DAIExceptionInformation daix = (DAIExceptionInformation)((Object)ex);
                message = this.getLocalizedMessage(batchID, daix.getErrorID(), daix.getParameters());
            } else {
                message = this.addIDToMessage(batchID, ex.getLocalizedMessage());
            }
            this.mLogger.fatal((Object)message);
        }
        if (stackTrace) {
            this.logStackTraceFatal(e);
        }
    }

    private String getLocalizedMessage(MessageID messageID, Object[] parameters) {
        return MessageLoader.getLocalizedMessage(messageID, parameters);
    }

    private String getLocalizedMessage(DAIUniqueID id, MessageID messageID, Object[] parameters) {
        String message = this.getLocalizedMessage(messageID, parameters);
        return this.addIDToMessage(id, message);
    }

    private String addIDToMessage(DAIUniqueID id, String message) {
        return "#" + id.toString() + "# " + message;
    }

    private String getStackTrace(Throwable ex) {
        StringWriter sw = new StringWriter();
        ex.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    private void logStackTraceDebug(Throwable e) {
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)this.getStackTrace(e));
        }
    }

    private void logStackTraceWarn(Throwable e) {
        this.mLogger.warn((Object)this.getStackTrace(e));
    }

    private void logStackTraceError(Throwable e) {
        this.mLogger.error((Object)this.getStackTrace(e));
    }

    private void logStackTraceFatal(Throwable e) {
        this.mLogger.fatal((Object)this.getStackTrace(e));
    }
}

