/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.common.files;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Map;
import uk.org.ogsadai.common.MemoryUtilities;
import uk.org.ogsadai.common.files.DAIDirectoryFoundException;
import uk.org.ogsadai.common.files.DAIDirectoryNotDirectoryException;
import uk.org.ogsadai.common.files.DAIDirectoryNotFoundException;
import uk.org.ogsadai.common.files.DAIDirectoryReadException;
import uk.org.ogsadai.common.files.DAIFileAlreadyExistsException;
import uk.org.ogsadai.common.files.DAIFileDeleteException;
import uk.org.ogsadai.common.files.DAIFileFoundException;
import uk.org.ogsadai.common.files.DAIFileNotFileException;
import uk.org.ogsadai.common.files.DAIFileNotFoundException;
import uk.org.ogsadai.common.files.DAIFileReadIOException;
import uk.org.ogsadai.common.files.DAIFileRenameException;
import uk.org.ogsadai.common.files.DAIFileWriteIOException;
import uk.org.ogsadai.common.files.FileLock;
import uk.org.ogsadai.common.msgs.DAILogger;

public class FileUtilities {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2005. (c) University of Edinburgh 2002 - 2005.";
    private static final DAILogger LOG = DAILogger.getLogger(FileUtilities.class);
    private static final FileUtilities SINGLETON = new FileUtilities();
    private static final FileLock LOCK = new FileLock();
    private static final int BUFFER_SIZE = 4096;

    private FileUtilities() {
    }

    public static FileUtilities getInstance() {
        return SINGLETON;
    }

    public static String readStringFromFile(String fileName) throws DAIFileNotFoundException, DAIFileNotFileException, DAIFileReadIOException {
        if (fileName == null) {
            throw new IllegalArgumentException("fileName must not be null");
        }
        StringBuffer sb = new StringBuffer();
        String fileDataString = null;
        File file = new File(fileName);
        if (!file.exists()) {
            throw new DAIFileNotFoundException(file);
        }
        if (!file.isFile()) {
            throw new DAIFileNotFileException(file);
        }
        try {
            LOCK.getReadLock(fileName);
            BufferedReader br = new BufferedReader(new FileReader(fileName));
            char[] charBuffer = new char[4096];
            int charsRead = 0;
            while ((charsRead = br.read(charBuffer)) != -1) {
                MemoryUtilities.checkMemory(charsRead * 2, LOG);
                sb.append(charBuffer, 0, charsRead);
            }
            fileDataString = sb.toString();
            br.close();
        }
        catch (IOException ioe) {
            throw new DAIFileReadIOException(file, ioe);
        }
        finally {
            LOCK.returnReadLock(fileName);
        }
        return fileDataString;
    }

    public static void replaceWriteStringToFile(String fileName, String data) throws DAIFileNotFileException, DAIFileWriteIOException {
        if (fileName == null) {
            throw new IllegalArgumentException("fileName must not be null");
        }
        File file = new File(fileName);
        if (file.exists() && file.isDirectory()) {
            throw new DAIFileNotFileException(file);
        }
        try {
            LOCK.getWriteLock(fileName);
            BufferedWriter bw = new BufferedWriter(new FileWriter(file));
            bw.write(data);
            bw.close();
        }
        catch (IOException ioe) {
            throw new DAIFileWriteIOException(file, ioe);
        }
        finally {
            LOCK.returnWriteLock(fileName);
        }
    }

    public static void writeStringToFile(String fileName, String data) throws DAIFileNotFileException, DAIFileWriteIOException, DAIFileAlreadyExistsException {
        if (fileName == null) {
            throw new IllegalArgumentException("fileName must not be null");
        }
        File file = new File(fileName);
        if (file.exists()) {
            if (file.isDirectory()) {
                throw new DAIFileNotFileException(file);
            }
            throw new DAIFileAlreadyExistsException(file);
        }
        try {
            LOCK.getWriteLock(fileName);
            BufferedWriter bw = new BufferedWriter(new FileWriter(file));
            bw.write(data);
            bw.close();
        }
        catch (IOException ioe) {
            throw new DAIFileWriteIOException(file, ioe);
        }
        finally {
            LOCK.returnWriteLock(fileName);
        }
    }

    public static byte[] readByteArrayFromFile(String fileName) throws DAIFileNotFoundException, DAIFileNotFileException, DAIFileReadIOException {
        if (fileName == null) {
            throw new IllegalArgumentException("fileName must not be null");
        }
        File file = new File(fileName);
        if (!file.exists()) {
            throw new DAIFileNotFoundException(file);
        }
        if (!file.isFile()) {
            throw new DAIFileNotFileException(file);
        }
        byte[] fileByteArray = null;
        try {
            LOCK.getReadLock(fileName);
            MemoryUtilities.checkMemory((int)file.length(), LOG);
            fileByteArray = new byte[(int)file.length()];
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));
            bis.read(fileByteArray);
            bis.close();
        }
        catch (IOException ioe) {
            throw new DAIFileReadIOException(file, ioe);
        }
        finally {
            LOCK.returnReadLock(fileName);
        }
        return fileByteArray;
    }

    public static void writeByteArrayToFile(String fileName, byte[] data) throws DAIFileNotFileException, DAIFileWriteIOException, DAIFileAlreadyExistsException {
        if (fileName == null) {
            throw new IllegalArgumentException("fileName must not be null");
        }
        if (data == null) {
            throw new IllegalArgumentException("data must not be null");
        }
        File file = new File(fileName);
        if (file.exists()) {
            if (file.isDirectory()) {
                throw new DAIFileNotFileException(file);
            }
            throw new DAIFileAlreadyExistsException(file);
        }
        try {
            LOCK.getWriteLock(fileName);
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(file));
            bos.write(data);
            bos.close();
        }
        catch (IOException ioe) {
            throw new DAIFileWriteIOException(file, ioe);
        }
        finally {
            LOCK.returnWriteLock(fileName);
        }
    }

    public static InputStream openStreamFromFile(String fileName) throws DAIFileNotFoundException, DAIFileNotFileException, DAIFileReadIOException {
        if (fileName == null) {
            throw new IllegalArgumentException("fileName must not be null");
        }
        File file = new File(fileName);
        if (!file.exists()) {
            throw new DAIFileNotFoundException(file);
        }
        if (!file.isFile()) {
            throw new DAIFileNotFileException(file);
        }
        FileInputStream fileDataStream = null;
        try {
            LOCK.getReadLock(fileName);
            fileDataStream = new FileInputStream(file);
        }
        catch (IOException ioe) {
            LOCK.returnReadLock(fileName);
            throw new DAIFileReadIOException(file, ioe);
        }
        return fileDataStream;
    }

    public static void closeStreamFromFile(String fileName, InputStream fileDataStream) throws DAIFileReadIOException {
        if (fileName == null) {
            throw new IllegalArgumentException("fileName must not be null");
        }
        if (fileDataStream == null) {
            throw new IllegalArgumentException("fileDataStream must not be null");
        }
        try {
            fileDataStream.close();
        }
        catch (IOException ioe) {
            throw new DAIFileReadIOException(new File(fileName), ioe);
        }
        finally {
            LOCK.returnReadLock(fileName);
        }
    }

    public static String readStringFromStream(InputStream inputStream) throws IOException {
        int bytesRead;
        if (inputStream == null) {
            throw new IllegalArgumentException("inputStream must not be null");
        }
        int BUFFER_SIZE = 1024;
        DataInputStream dis = new DataInputStream(inputStream);
        StringBuffer sb = new StringBuffer();
        byte[] bytes = new byte[1024];
        do {
            if ((bytesRead = dis.read(bytes)) <= 0) continue;
            sb.append(new String(bytes, 0, bytesRead));
        } while (bytesRead > 0);
        dis.close();
        return sb.toString();
    }

    public static OutputStream openStreamToFile(String fileName) throws DAIFileNotFileException, DAIFileWriteIOException {
        if (fileName == null) {
            throw new IllegalArgumentException("fileName must not be null");
        }
        File file = new File(fileName);
        if (file.exists() && file.isDirectory()) {
            throw new DAIFileNotFileException(file);
        }
        FileOutputStream fileDataStream = null;
        try {
            LOCK.getWriteLock(fileName);
            fileDataStream = new FileOutputStream(file);
        }
        catch (IOException ioe) {
            LOCK.returnWriteLock(fileName);
            throw new DAIFileWriteIOException(file, ioe);
        }
        return fileDataStream;
    }

    public static void closeStreamToFile(String fileName, OutputStream fileDataStream) throws DAIFileWriteIOException {
        if (fileName == null) {
            throw new IllegalArgumentException("fileName must not be null");
        }
        if (fileDataStream == null) {
            throw new IllegalArgumentException("fileDataStream must not be null");
        }
        try {
            fileDataStream.close();
        }
        catch (IOException ioe) {
            throw new DAIFileWriteIOException(new File(fileName), ioe);
        }
        finally {
            LOCK.returnWriteLock(fileName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void renameFile(String fileName, String newFileName) throws DAIFileNotFileException, DAIFileWriteIOException, DAIFileRenameException, DAIFileAlreadyExistsException, DAIFileNotFoundException {
        if (fileName == null) {
            throw new IllegalArgumentException("fileName must not be null");
        }
        if (newFileName == null) {
            throw new IllegalArgumentException("newFileName must not be null");
        }
        File file = new File(fileName);
        if (file.exists() && file.isDirectory()) {
            throw new DAIFileNotFileException(file);
        }
        if (!file.exists()) {
            throw new DAIFileNotFoundException(file);
        }
        File newFile = new File(newFileName);
        if (newFile.isDirectory()) {
            throw new DAIFileNotFileException(newFile);
        }
        if (newFile.exists()) {
            throw new DAIFileAlreadyExistsException(newFile);
        }
        try {
            LOCK.getWriteLock(fileName);
            LOCK.getWriteLock(newFileName);
            if (!file.renameTo(newFile)) {
                throw new DAIFileRenameException(file);
            }
        }
        finally {
            LOCK.returnWriteLock(fileName);
            LOCK.returnWriteLock(newFileName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteFile(String fileName) throws DAIFileNotFileException, DAIFileWriteIOException, DAIFileDeleteException, DAIFileNotFoundException {
        if (fileName == null) {
            throw new IllegalArgumentException("fileName must not be null");
        }
        File file = new File(fileName);
        if (file.exists() && file.isDirectory()) {
            throw new DAIFileNotFileException(file);
        }
        if (!file.exists()) {
            throw new DAIFileNotFoundException(file);
        }
        try {
            LOCK.getWriteLock(fileName);
            if (!file.delete()) {
                throw new DAIFileDeleteException(file);
            }
        }
        finally {
            LOCK.returnWriteLock(fileName);
        }
    }

    public static File getFile(String baseDir, String filename) {
        if (baseDir == null) {
            throw new IllegalArgumentException("baseDir must not be null");
        }
        if (filename == null) {
            throw new IllegalArgumentException("filename must not be null");
        }
        File file = new File(filename);
        if (!file.isAbsolute() && baseDir != null) {
            file = new File(baseDir, filename);
        }
        return file;
    }

    public static void replaceTokensInDirectory(File dir, Map tokensAndValues) throws DAIFileReadIOException, DAIFileWriteIOException, DAIDirectoryNotFoundException, DAIDirectoryNotDirectoryException {
        if (dir == null) {
            throw new IllegalArgumentException("dir must not be null");
        }
        if (!dir.exists()) {
            throw new DAIDirectoryNotFoundException(dir);
        }
        if (!dir.isDirectory()) {
            throw new DAIDirectoryNotDirectoryException(dir);
        }
        if (dir.isDirectory()) {
            String[] children = dir.list();
            int numChildren = children.length;
            for (int i = 0; i < numChildren; ++i) {
                File child = new File(dir, children[i]);
                if (child.isFile()) {
                    try {
                        FileUtilities.replaceTokensInFile(child, tokensAndValues);
                    }
                    catch (DAIFileNotFoundException e) {
                    }
                    catch (DAIFileNotFileException e) {}
                    continue;
                }
                if (!child.isDirectory()) continue;
                FileUtilities.replaceTokensInDirectory(child, tokensAndValues);
            }
        }
    }

    public static void replaceTokensInFile(File file, Map tokensAndValues) throws DAIFileNotFoundException, DAIFileNotFileException, DAIFileReadIOException, DAIFileWriteIOException {
        String fileText;
        if (file == null) {
            throw new IllegalArgumentException("file must not be null");
        }
        if (tokensAndValues == null) {
            throw new IllegalArgumentException("tokensAndValues must not be null");
        }
        if (!file.isDirectory()) {
            fileText = FileUtilities.readStringFromFile(file.getAbsolutePath());
            Iterator i = tokensAndValues.keySet().iterator();
            while (i.hasNext()) {
                String token = i.next().toString();
                String value = tokensAndValues.get(token).toString();
                fileText = fileText.replaceAll(token, value);
            }
        } else {
            throw new DAIFileNotFileException(file);
        }
        FileUtilities.replaceWriteStringToFile(file.getAbsolutePath(), fileText);
    }

    public static boolean deleteDir(File dir) {
        if (dir == null) {
            throw new IllegalArgumentException("dir must not be null");
        }
        if (dir.isDirectory()) {
            boolean result = true;
            result = result && FileUtilities.deleteDirContents(dir);
            result = result && dir.delete();
            return result;
        }
        return false;
    }

    public static boolean deleteDirContents(File dir) {
        if (dir == null) {
            throw new IllegalArgumentException("dir must not be null");
        }
        boolean success = true;
        if (dir.isDirectory()) {
            String[] children = dir.list();
            int numChildren = children.length;
            for (int i = 0; i < numChildren; ++i) {
                File child = new File(dir, children[i]);
                success = child.isDirectory() ? success && FileUtilities.deleteDir(new File(dir, children[i])) : success && child.delete();
            }
        } else {
            success = false;
        }
        return success;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void copyFile(File sourceFile, File destinationFile) throws DAIFileNotFoundException, DAIFileReadIOException, DAIFileWriteIOException, DAIFileNotFileException {
        if (sourceFile == null) {
            throw new IllegalArgumentException("sourceFile must not be null");
        }
        if (destinationFile == null) {
            throw new IllegalArgumentException("destinationFile must not be null");
        }
        if (!sourceFile.exists()) {
            throw new DAIFileNotFoundException(sourceFile);
        }
        if (sourceFile.isDirectory()) {
            throw new DAIFileNotFileException(sourceFile);
        }
        FileInputStream fis = null;
        FileOutputStream fos = null;
        boolean write = false;
        try {
            try {
                fis = new FileInputStream(sourceFile);
                fos = new FileOutputStream(destinationFile);
                byte[] buf = new byte[4096];
                int i = 0;
                while ((i = fis.read(buf)) != -1) {
                    write = true;
                    fos.write(buf, 0, i);
                    write = false;
                }
                Object var8_10 = null;
            }
            catch (FileNotFoundException e) {
                File missingFile = fis == null ? sourceFile : destinationFile;
                throw new DAIFileNotFoundException(missingFile);
            }
            catch (IOException e) {
                if (!write) throw new DAIFileReadIOException(sourceFile, e);
                throw new DAIFileWriteIOException(destinationFile, e);
            }
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            try {
                if (fis != null) {
                    fis.close();
                    fis = null;
                }
                if (fos == null) throw throwable;
                fos.close();
                fos = null;
                throw throwable;
            }
            catch (IOException e) {
                if (fis != null) throw new DAIFileReadIOException(sourceFile, e);
                throw new DAIFileWriteIOException(destinationFile, e);
            }
        }
        try {}
        catch (IOException e) {
            if (fis != null) throw new DAIFileReadIOException(sourceFile, e);
            throw new DAIFileWriteIOException(destinationFile, e);
        }
        if (fis != null) {
            fis.close();
            fis = null;
        }
        if (fos == null) return;
        fos.close();
    }

    public static void copyDirectoryContents(File sourceDir, File destinationDir) throws DAIDirectoryNotFoundException, DAIDirectoryNotDirectoryException, DAIFileReadIOException, DAIFileWriteIOException {
        if (sourceDir == null) {
            throw new IllegalArgumentException("sourceDir must not be null");
        }
        if (destinationDir == null) {
            throw new IllegalArgumentException("destinationDir must not be null");
        }
        if (!sourceDir.exists()) {
            throw new DAIDirectoryNotFoundException(sourceDir);
        }
        if (!destinationDir.exists()) {
            throw new DAIDirectoryNotFoundException(destinationDir);
        }
        if (!sourceDir.isDirectory()) {
            throw new DAIDirectoryNotDirectoryException(sourceDir);
        }
        if (!destinationDir.isDirectory()) {
            throw new DAIDirectoryNotDirectoryException(destinationDir);
        }
        String[] children = sourceDir.list();
        int numChildren = children.length;
        for (int i = 0; i < numChildren; ++i) {
            File sourceFile = new File(sourceDir, children[i]);
            File destFile = new File(destinationDir, children[i]);
            if (sourceFile.isFile()) {
                try {
                    FileUtilities.copyFile(sourceFile, destFile);
                }
                catch (DAIFileNotFileException e) {
                }
                catch (DAIFileNotFoundException e) {}
                continue;
            }
            if (!sourceFile.isDirectory()) continue;
            destFile.mkdir();
            FileUtilities.copyDirectoryContents(sourceFile, destFile);
        }
    }

    public static void fileExists(File file) throws DAIFileNotFoundException {
        if (!file.exists()) {
            throw new DAIFileNotFoundException(file);
        }
    }

    public static void fileDoesntExist(File file) throws DAIFileFoundException {
        if (file.exists()) {
            throw new DAIFileFoundException(file);
        }
    }

    public static void directoryExists(File dir) throws DAIDirectoryNotFoundException {
        if (!dir.exists()) {
            throw new DAIDirectoryNotFoundException(dir);
        }
    }

    public static void directoryDoesntExist(File dir) throws DAIDirectoryFoundException {
        if (dir.exists()) {
            throw new DAIDirectoryFoundException(dir);
        }
    }

    public static void isDirectory(File file) throws DAIDirectoryNotDirectoryException {
        if (!file.isDirectory()) {
            throw new DAIDirectoryNotDirectoryException(file);
        }
    }

    public static void isFileReadable(File file) throws DAIFileReadIOException {
        if (!file.canRead()) {
            throw new DAIFileReadIOException(file);
        }
    }

    public static void isFileWritable(File file) throws DAIFileWriteIOException {
        if (!file.canWrite()) {
            throw new DAIFileWriteIOException(file);
        }
    }

    public static void isDirectoryReadable(File dir) throws DAIDirectoryReadException {
        if (!dir.canRead()) {
            throw new DAIDirectoryReadException(dir);
        }
    }
}

