/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.common.files;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import uk.org.ogsadai.common.files.FileLockException;
import uk.org.ogsadai.common.files.NoExistingFileLockException;
import uk.org.ogsadai.common.msgs.DAILogger;

public class FileLock {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2005. (c) University of Edinburgh 2002 - 2005.";
    private static DAILogger LOG = DAILogger.getLogger(FileLock.class);
    private Map readers = new HashMap();
    private Map writers = new HashMap();

    public synchronized void doLocking(String fileName, boolean lock, boolean read) throws FileLockException {
        if (lock) {
            if (read) {
                this.getReadLock(fileName);
            } else {
                this.getWriteLock(fileName);
            }
        } else if (read) {
            this.returnReadLock(fileName);
        } else {
            this.returnWriteLock(fileName);
        }
    }

    public synchronized void getReadLock(String fileName) throws FileLockException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Requesting read lock for " + fileName + "...");
        }
        try {
            while (this.countWriters(fileName) > 0) {
                this.wait();
            }
            this.incrementReaders(fileName);
        }
        catch (InterruptedException e) {
            throw new FileLockException(fileName, e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Obtained read lock for " + fileName);
        }
    }

    public synchronized void returnReadLock(String fileName) throws NoExistingFileLockException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Returning read lock for " + fileName + "...");
        }
        this.decrementReaders(fileName);
        this.notifyAll();
    }

    public synchronized void getWriteLock(String fileName) throws FileLockException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Requesting write lock for " + fileName + "...");
        }
        try {
            while (this.countWriters(fileName) > 0 || this.countReaders(fileName) > 0) {
                this.wait();
            }
            this.incrementWriters(fileName);
        }
        catch (InterruptedException e) {
            throw new FileLockException(fileName, e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Obtained write lock for " + fileName);
        }
    }

    public synchronized void returnWriteLock(String fileName) throws NoExistingFileLockException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Returning write lock for " + fileName + "...");
        }
        this.decrementWriters(fileName);
        this.notifyAll();
    }

    public synchronized int countReaders(String fileName) {
        Integer num = (Integer)this.readers.get(this.canonical(fileName));
        if (num == null) {
            return 0;
        }
        return num;
    }

    public synchronized int countWriters(String fileName) {
        Integer num = (Integer)this.writers.get(this.canonical(fileName));
        if (num == null) {
            return 0;
        }
        return num;
    }

    private synchronized void setReaders(String fileName, int number) {
        fileName = this.canonical(fileName);
        this.readers.put(fileName, new Integer(number));
    }

    private synchronized void setWriters(String fileName, int number) {
        fileName = this.canonical(fileName);
        this.writers.put(fileName, new Integer(number));
    }

    private synchronized void incrementReaders(String fileName) {
        fileName = this.canonical(fileName);
        this.setReaders(fileName, this.countReaders(fileName) + 1);
    }

    private synchronized void decrementReaders(String fileName) {
        int count = this.countReaders(fileName = this.canonical(fileName));
        if (count == 0) {
            throw new NoExistingFileLockException(fileName);
        }
        this.setReaders(fileName, count - 1);
    }

    private synchronized void incrementWriters(String fileName) {
        fileName = this.canonical(fileName);
        this.setWriters(fileName, this.countWriters(fileName) + 1);
    }

    private synchronized void decrementWriters(String fileName) {
        int count = this.countWriters(fileName = this.canonical(fileName));
        if (count == 0) {
            throw new NoExistingFileLockException(fileName);
        }
        this.setWriters(fileName, count - 1);
    }

    private String canonical(String fileName) {
        try {
            return new File(fileName).getCanonicalPath();
        }
        catch (IOException e) {
            return fileName;
        }
        catch (SecurityException e) {
            return fileName;
        }
    }
}

