/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.common;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.w3c.dom.Node;
import uk.org.ogsadai.common.BlockBuffer;
import uk.org.ogsadai.common.MemoryUtilities;
import uk.org.ogsadai.common.OutOfMemoryException;
import uk.org.ogsadai.common.msgs.DAILogger;
import uk.org.ogsadai.common.xml.XMLUtilities;

public class SimpleBlockBuffer
implements BlockBuffer {
    private static final String COPYRIGHT_NOTICE = "(c) University of Edinburgh 2005";
    private static final DAILogger LOG = DAILogger.getLogger(SimpleBlockBuffer.class);
    private final StringBuffer mStringData = new StringBuffer();
    private final ByteArrayOutputStream mBinaryData = new ByteArrayOutputStream();
    private int mSize;

    public void appendBlock(Object block) throws OutOfMemoryException {
        if (block != null) {
            if (block instanceof byte[]) {
                this.appendByteArray((byte[])block);
            } else if (block instanceof Node) {
                this.appendNode(block);
            } else {
                this.mStringData.append(block);
            }
            ++this.mSize;
        }
    }

    public Object toBlock() throws OutOfMemoryException {
        Object block = null;
        if (this.mStringData.length() > 0) {
            MemoryUtilities.checkMemory(this.mStringData, LOG);
            block = this.mStringData.toString();
        } else if (this.mBinaryData.size() > 0) {
            MemoryUtilities.checkMemory(this.mBinaryData, LOG);
            block = this.mBinaryData.toByteArray();
        }
        return block;
    }

    private void appendByteArray(byte[] block) throws OutOfMemoryException {
        try {
            byte[] byteBlock = block;
            MemoryUtilities.checkMemory(byteBlock, LOG);
            this.mBinaryData.write(byteBlock);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void appendNode(Object block) throws OutOfMemoryException {
        String xml = XMLUtilities.xmlDOMToString((Node)block);
        MemoryUtilities.checkMemory(xml, LOG);
        this.mStringData.append(xml);
    }

    public int size() {
        return this.mSize;
    }
}

