/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.common;

import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import uk.org.ogsadai.common.GridCredentialAccessException;
import uk.org.ogsadai.common.NoGridCredentialException;
import uk.org.ogsadai.common.msgs.DAILogger;

public class SecurityContext {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2005. (c) University of Edinburgh 2002 - 2005";
    private static final DAILogger LOG = DAILogger.getLogger(SecurityContext.class);
    public static final String NO_CERTIFICATE_PROVIDED = "No Certificate Provided";
    private String mDistinguishedName = null;
    private GSSCredential mCredential = null;

    public SecurityContext(String distinguishedName, GSSCredential credential) {
        this.mCredential = credential;
        if (distinguishedName == null) {
            String dnFromCredential = this.getDNFromCredential(credential);
            this.setDN(dnFromCredential);
        } else {
            this.setDN(distinguishedName);
        }
    }

    public GSSCredential getCredential() {
        return this.mCredential;
    }

    public String getDN() {
        return this.mDistinguishedName;
    }

    public void setCredential(GSSCredential credential) {
        this.mCredential = credential;
        String dn = this.getDNFromCredential(credential);
        if (dn != null) {
            this.setDN(dn);
        }
    }

    private String getDNFromCredential(GSSCredential credential) {
        if (this.mCredential != null) {
            try {
                return ((Object)credential.getName()).toString();
            }
            catch (GSSException e) {
                GridCredentialAccessException ex = new GridCredentialAccessException(e);
                LOG.warn(ex);
            }
        }
        return null;
    }

    public void setDN(String distinguishedName) {
        this.mDistinguishedName = distinguishedName;
        if (this.mDistinguishedName == null) {
            if (LOG.isInfoEnabled()) {
                NoGridCredentialException ex = new NoGridCredentialException(NO_CERTIFICATE_PROVIDED);
                LOG.warn(ex);
            }
            this.mDistinguishedName = NO_CERTIFICATE_PROVIDED;
        }
    }
}

