/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.common;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import org.w3c.dom.Document;
import uk.org.ogsadai.common.xml.XMLParseException;
import uk.org.ogsadai.common.xml.XMLUtilities;
import uk.org.ogsadai.exception.DAIMalformedURLException;
import uk.org.ogsadai.exception.DAIURLReadIOException;

public class NetUtilities {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2005. (c) University of Edinburgh 2002 - 2005.";

    public static Document readToDocument(String url, boolean validate) throws DAIMalformedURLException, DAIURLReadIOException, XMLParseException {
        return XMLUtilities.xmlStringToDOM(NetUtilities.readToString(url), validate);
    }

    public static String readToString(String url) throws DAIMalformedURLException, DAIURLReadIOException {
        try {
            return NetUtilities.readToString(new URL(url));
        }
        catch (MalformedURLException e) {
            throw new DAIMalformedURLException(url);
        }
    }

    public static String readToString(URL url) throws DAIURLReadIOException {
        StringBuffer s = new StringBuffer();
        try {
            int length;
            BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream()));
            char[] chars = new char[128];
            while ((length = in.read(chars, 0, chars.length)) != -1) {
                s.append(chars, 0, length);
            }
            in.close();
        }
        catch (IOException e) {
            throw new DAIURLReadIOException(url, e);
        }
        return s.toString();
    }

    public static boolean sameFile(URL url1, URL url2) {
        if (url1.getProtocol().equalsIgnoreCase("file") && url2.getProtocol().equalsIgnoreCase("file")) {
            return url1.getPath().equals(url2.getPath());
        }
        return url1.sameFile(url2);
    }

    public static String getMachineIPAddress() throws UnknownHostException {
        InetAddress hostAddr = InetAddress.getLocalHost();
        String machineName = hostAddr.getHostAddress();
        return machineName;
    }
}

