/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.common;

import java.io.ByteArrayOutputStream;
import uk.org.ogsadai.common.OutOfMemoryException;
import uk.org.ogsadai.common.msgs.DAILogger;

public class MemoryUtilities {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2005. (c) University of Edinburgh 2002 - 2005.";
    private static final DAILogger LOG = DAILogger.getLogger(MemoryUtilities.class);
    private static final Runtime RUNTIME = Runtime.getRuntime();
    private static final long MAX_MEMORY = RUNTIME.maxMemory();
    public static final double THRESHOLD = 0.85;

    public static void checkMemory(String stringToCopy, DAILogger log) throws OutOfMemoryException {
        if (stringToCopy != null) {
            MemoryUtilities.checkMemory(96 + stringToCopy.length() * 2, log);
        }
    }

    public static void checkMemory(byte[] bytes, DAILogger log) throws OutOfMemoryException {
        MemoryUtilities.checkMemory(bytes.length * 4 / 3, log);
    }

    public static void checkMemory(StringBuffer buffer, DAILogger log) throws OutOfMemoryException {
        MemoryUtilities.checkMemory(buffer.length() * 2, log);
    }

    public static void checkMemory(ByteArrayOutputStream stream, DAILogger log) throws OutOfMemoryException {
        MemoryUtilities.checkMemory(stream.size() * 4 / 3, log);
    }

    public static synchronized void checkMemory(int numberOfBytesToAdd, DAILogger log) throws OutOfMemoryException {
        MemoryUtilities.logMemoryUsage(log);
        double currentRatio = MemoryUtilities.getCurrentRatio(numberOfBytesToAdd);
        if (currentRatio > 0.85) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Adding " + numberOfBytesToAdd + " bytes will go over threshold - attempting to garbage collect");
            }
            RUNTIME.gc();
            RUNTIME.runFinalization();
            RUNTIME.gc();
            RUNTIME.runFinalization();
            RUNTIME.gc();
            RUNTIME.runFinalization();
            RUNTIME.gc();
            currentRatio = MemoryUtilities.getCurrentRatio(numberOfBytesToAdd);
            if (currentRatio > 0.85) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Still over threshold - throwing exception to protect OGSA-DAI");
                }
                throw new OutOfMemoryException(numberOfBytesToAdd);
            }
        }
        MemoryUtilities.logMemoryUsage(log);
    }

    private static double getCurrentRatio(int numberOfBytesToAdd) {
        return (double)(MemoryUtilities.getCurrentlyUsedMemory() + (long)numberOfBytesToAdd) / (double)MAX_MEMORY;
    }

    private static long getCurrentlyUsedMemory() {
        return RUNTIME.totalMemory() - RUNTIME.freeMemory();
    }

    public static void logMemoryUsage(DAILogger log) {
        String msg = null;
        if (log != null && log.isDebugEnabled()) {
            msg = "[" + MemoryUtilities.getCurrentlyUsedMemory() + "] of [" + MAX_MEMORY + "] bytes in use. [" + MemoryUtilities.getCurrentRatio(0) * 100.0 + "]%";
            log.debug(msg);
        } else if (LOG.isDebugEnabled()) {
            msg = "[" + MemoryUtilities.getCurrentlyUsedMemory() + "] of [" + MAX_MEMORY + "] bytes in use. [" + MemoryUtilities.getCurrentRatio(0) * 100.0 + "]%";
            LOG.debug(msg);
        }
    }
}

