/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.common;

import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import uk.org.ogsadai.common.Queue;

public class FIFOQueue
implements Queue {
    private static final String COPYRIGHT_NOTICE = "(c) University of Edinburgh 2002 - 2005.";
    public static final int DEFAULT_CAPACITY = 10;
    protected final Object[] mData;
    protected int mCapacity;
    private int mSize;
    private int mHeadIndex;
    private int mTailIndex;
    private long mModificationCount;

    public FIFOQueue(int capacity) throws IllegalArgumentException {
        if (capacity < 1) {
            throw new IllegalArgumentException("Queue capacity must be >= 1");
        }
        this.mData = new Object[capacity];
        for (int i = 0; i < capacity; ++i) {
            this.mData[i] = null;
        }
        this.mSize = 0;
        this.mCapacity = capacity;
        this.mTailIndex = 0;
        this.mHeadIndex = 0;
        this.mModificationCount = 0L;
    }

    public FIFOQueue() {
        this(10);
    }

    public boolean offer(Object obj) throws IllegalArgumentException {
        if (obj == null) {
            throw new IllegalArgumentException("Object must not be null");
        }
        if (this.mSize == this.mCapacity) {
            return false;
        }
        this.mData[this.mTailIndex] = obj;
        this.mTailIndex = this.inc(this.mTailIndex);
        ++this.mSize;
        ++this.mModificationCount;
        return true;
    }

    public Object poll() {
        if (this.mSize == 0) {
            return null;
        }
        Object obj = this.mData[this.mHeadIndex];
        this.mData[this.mHeadIndex] = null;
        this.mHeadIndex = this.inc(this.mHeadIndex);
        --this.mSize;
        ++this.mModificationCount;
        return obj;
    }

    public Object remove() throws NoSuchElementException {
        if (this.mSize == 0) {
            throw new NoSuchElementException("Queue is empty");
        }
        return this.poll();
    }

    public void remove(Object item) throws NoSuchElementException {
        if (item != null && this.mSize > 0) {
            int index = this.mHeadIndex;
            boolean shift = false;
            for (int count = 0; count < this.mSize; ++count) {
                if (this.mData[index] == item) {
                    shift = true;
                    this.mTailIndex = this.dec(this.mTailIndex);
                    ++this.mModificationCount;
                    --this.mSize;
                }
                if (shift && count < this.mSize) {
                    this.mData[index] = this.mData[this.inc(index)];
                }
                index = this.inc(index);
            }
        }
    }

    public Object peek() {
        if (this.mSize == 0) {
            return null;
        }
        return this.mData[this.mHeadIndex];
    }

    public Object element() throws NoSuchElementException {
        if (this.mSize == 0) {
            throw new NoSuchElementException("Queue is empty");
        }
        return this.peek();
    }

    public int size() {
        return this.mSize;
    }

    public Iterator iterator() {
        return new LocalIterator();
    }

    private final int inc(int index) {
        return ++index == this.mCapacity ? 0 : index;
    }

    private final int dec(int index) {
        return --index == -1 ? this.mCapacity - 1 : index;
    }

    protected class LocalIterator
    implements Iterator {
        private long mExpectedModificationCount;
        private int mCursor;
        private int mInvocation;
        private int mElementCount;

        public LocalIterator() {
            this.mExpectedModificationCount = FIFOQueue.this.mModificationCount;
            this.mCursor = FIFOQueue.this.mHeadIndex;
            this.mInvocation = 0;
            this.mElementCount = FIFOQueue.this.mSize;
        }

        private void checkUnmodified() throws ConcurrentModificationException {
            if (FIFOQueue.this.mModificationCount != this.mExpectedModificationCount) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean hasNext() {
            return this.mInvocation < this.mElementCount;
        }

        public Object next() throws NoSuchElementException, ConcurrentModificationException {
            this.checkUnmodified();
            if (!this.hasNext()) {
                throw new NoSuchElementException("There is no next element");
            }
            ++this.mInvocation;
            Object obj = FIFOQueue.this.mData[this.mCursor];
            this.mCursor = FIFOQueue.this.inc(this.mCursor);
            return obj;
        }

        public void remove() throws IllegalStateException, UnsupportedOperationException {
            throw new UnsupportedOperationException("remove");
        }
    }
}

