/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.common;

import org.w3c.dom.Document;
import uk.org.ogsadai.common.DocumentValidationException;
import uk.org.ogsadai.common.msgs.DAILogger;

public abstract class DocumentValidator {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2005. (c) University of Edinburgh 2002 - 2005.";
    private static final DAILogger LOG = DAILogger.getLogger(DocumentValidator.class);
    private DocumentValidator mSuccessor;

    public final void setSuccessor(DocumentValidator validator) {
        this.mSuccessor = validator;
    }

    public final void validate(Document doc) throws DocumentValidationException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Starting validation using " + this.toString());
        }
        this.performValidation(doc);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Finished validation using " + this.toString());
        }
        if (this.mSuccessor != null) {
            this.mSuccessor.validate(doc);
        }
    }

    protected abstract void performValidation(Document var1) throws DocumentValidationException;
}

