/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.common;

public class CircularBuffer {
    private static final String COPYRIGHT_NOTICE = "(c) University of Edinburgh 2002 - 2005.";
    private static final int DEFAULT_SIZE = 1024;
    private final Object[] mBuffer;
    private volatile int mReadIndex = 0;
    private volatile int mWriteIndex = 0;
    private boolean mOpen = true;

    public CircularBuffer() {
        this.mBuffer = new Object[1024];
    }

    public CircularBuffer(int size) {
        this.mBuffer = new Object[size];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object read() throws InterruptedException {
        while (true) {
            CircularBuffer circularBuffer = this;
            synchronized (circularBuffer) {
                int remaining = this.blocksAvailable();
                if (remaining > 0) {
                    Object block = this.mBuffer[this.mReadIndex];
                    ++this.mReadIndex;
                    if (this.mReadIndex == this.mBuffer.length) {
                        this.mReadIndex = 0;
                    }
                    this.notify();
                    return block;
                }
                if (!this.mOpen) {
                    this.notify();
                    return null;
                }
                this.wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(Object block) throws InterruptedException {
        boolean writing = true;
        while (writing) {
            CircularBuffer circularBuffer = this;
            synchronized (circularBuffer) {
                if (!this.mOpen) {
                    throw new IllegalStateException("Buffer is closed");
                }
                int space = this.freeSpace();
                if (space > 0) {
                    this.mBuffer[this.mWriteIndex] = block;
                    block = null;
                    ++this.mWriteIndex;
                    if (this.mWriteIndex == this.mBuffer.length) {
                        this.mWriteIndex = 0;
                    }
                    writing = false;
                    this.notify();
                }
                if (writing) {
                    this.wait();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        CircularBuffer circularBuffer = this;
        synchronized (circularBuffer) {
            this.mOpen = false;
            this.notify();
        }
    }

    private int freeSpace() {
        if (this.mWriteIndex < this.mReadIndex) {
            return this.mReadIndex - this.mWriteIndex - 1;
        }
        return this.mBuffer.length - 1 - (this.mWriteIndex - this.mReadIndex);
    }

    private int blocksAvailable() {
        if (this.mReadIndex <= this.mWriteIndex) {
            return this.mWriteIndex - this.mReadIndex;
        }
        return this.mBuffer.length - (this.mReadIndex - this.mWriteIndex);
    }
}

