/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.common;

import java.io.IOException;
import java.io.Writer;
import uk.org.ogsadai.common.BlockWriter;

public class BlockWriterWriter
extends Writer {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2005. (c) University of Edinburgh 2002 - 2005.";
    private static final int BUFFER_SIZE = 1024;
    private final char[] mBuffer = new char[2048];
    private int mCurrentPosition = 0;
    private final BlockWriter mBlockWriter;

    public BlockWriterWriter(BlockWriter writer) {
        this.mBlockWriter = writer;
    }

    public void close() throws IOException {
        if (this.mCurrentPosition > 0) {
            this.mBlockWriter.put(new String(this.mBuffer, 0, this.mCurrentPosition));
            this.mCurrentPosition = 0;
        }
        this.mBlockWriter.close();
    }

    public void flush() throws IOException {
        if (this.mCurrentPosition > 0) {
            this.mBlockWriter.put(new String(this.mBuffer, 0, this.mCurrentPosition));
            this.mCurrentPosition = 0;
        }
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        if (len + this.mCurrentPosition <= 1024) {
            System.arraycopy(cbuf, off, this.mBuffer, this.mCurrentPosition, len);
            this.mCurrentPosition += len;
        } else if (len > 1024) {
            this.mBlockWriter.put(new String(this.mBuffer, 0, this.mCurrentPosition));
            this.mBlockWriter.put(new String(cbuf, off, len));
            this.mCurrentPosition = 0;
        } else {
            System.arraycopy(cbuf, off, this.mBuffer, this.mCurrentPosition, len);
            this.mCurrentPosition += len;
            this.mBlockWriter.put(new String(this.mBuffer, 0, this.mCurrentPosition));
            this.mCurrentPosition = 0;
        }
    }
}

