/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.common;

import java.io.IOException;
import java.io.Reader;
import org.w3c.dom.Node;
import uk.org.ogsadai.common.BlockReader;
import uk.org.ogsadai.common.ReaderClosedException;
import uk.org.ogsadai.common.UnsupportedBlockException;
import uk.org.ogsadai.common.xml.XMLUtilities;

public class BlockReaderReader
extends Reader {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2005. (c) University of Edinburgh 2002 - 2005.";
    private boolean mOpen = true;
    private final BlockReader mBlockReader;
    private final StringBuffer mBuffer = new StringBuffer();

    public BlockReaderReader(BlockReader blockReader) {
        this.mBlockReader = blockReader;
    }

    public void close() {
        if (this.mOpen) {
            this.mBuffer.delete(0, this.mBuffer.length());
            this.mOpen = false;
        }
    }

    public int read(char[] buffer, int offset, int length) throws IOException {
        if (this.mOpen) {
            while (this.mBuffer.length() < length && this.mBlockReader.hasNext()) {
                Object o = this.mBlockReader.next();
                if (o instanceof byte[]) {
                    this.mBuffer.append(new String((byte[])o));
                    continue;
                }
                if (o instanceof String) {
                    this.mBuffer.append((String)o);
                    continue;
                }
                if (o instanceof Node) {
                    this.appendNode((Node)o);
                    continue;
                }
                String name = null;
                if (o != null) {
                    name = o.getClass().getName();
                }
                UnsupportedBlockException ex = new UnsupportedBlockException(name);
                IOException ioex = new IOException(ex.getLocalizedMessage());
                ioex.initCause(ex);
                throw ioex;
            }
            if (this.mBuffer.length() < length) {
                length = this.mBuffer.length();
            }
            if (length > 0) {
                this.mBuffer.getChars(0, length, buffer, offset);
                this.mBuffer.delete(0, length);
            } else {
                length = -1;
            }
        } else {
            ReaderClosedException ex = new ReaderClosedException();
            IOException ioex = new IOException(ex.getLocalizedMessage());
            ioex.initCause(ex);
            throw ioex;
        }
        return length;
    }

    private void appendNode(Node node) {
        this.mBuffer.append(XMLUtilities.xmlDOMToString(node));
    }
}

