/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.common;

import java.io.IOException;
import java.io.InputStream;
import org.w3c.dom.Node;
import uk.org.ogsadai.common.BlockReader;
import uk.org.ogsadai.common.UnsupportedBlockException;
import uk.org.ogsadai.common.xml.XMLUtilities;

public class BlockReaderInputStream
extends InputStream {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2005. (c) University of Edinburgh 2002 - 2005.";
    private final BlockReader mBlockReader;
    private byte[] mBlock;
    private int mIndex;
    private int mAvailable;
    private int mNeeded;
    private int mAmount;
    private int mBytesRead;
    private boolean mActive = true;
    private byte[] mByte = new byte[1];

    public BlockReaderInputStream(BlockReader blockReader) {
        this.mBlockReader = blockReader;
    }

    public int read(byte[] bytes, int index, int length) throws IOException {
        this.mBytesRead = 0;
        this.mAmount = 0;
        this.mNeeded = 0;
        this.mAvailable = 0;
        if (this.mBlock == null) {
            this.nextBlock();
        }
        while (this.mActive && this.mBytesRead < length) {
            this.mAvailable = this.mBlock.length - this.mIndex;
            this.mNeeded = length - this.mBytesRead;
            this.mAmount = this.mNeeded > this.mAvailable ? this.mAvailable : this.mNeeded;
            System.arraycopy(this.mBlock, this.mIndex, bytes, index, this.mAmount);
            this.mBytesRead += this.mAmount;
            index += this.mAmount;
            this.mIndex += this.mAmount;
            if (this.mIndex < this.mBlock.length) continue;
            this.nextBlock();
        }
        if (!this.mActive && this.mBytesRead == 0) {
            this.mBytesRead = -1;
        }
        return this.mBytesRead;
    }

    public int read() throws IOException {
        int b = this.read(this.mByte, 0, 1);
        if (b == 1) {
            b = this.mByte[0] & 0xFF;
        }
        return b;
    }

    private void nextBlock() throws IOException {
        Object object = null;
        while ((object == null || this.mBlock.length == 0) && this.mActive) {
            if (this.mBlockReader.hasNext()) {
                object = this.mBlockReader.next();
                if (object instanceof byte[]) {
                    this.mBlock = (byte[])object;
                    continue;
                }
                if (object instanceof String) {
                    this.mBlock = ((String)object).getBytes();
                    continue;
                }
                if (object instanceof Node) {
                    this.getNodeBlock((Node)object);
                    continue;
                }
                String name = null;
                if (object != null) {
                    name = object.getClass().getName();
                }
                UnsupportedBlockException ex = new UnsupportedBlockException(name);
                IOException ioex = new IOException(ex.getLocalizedMessage());
                ioex.initCause(ex);
                throw ioex;
            }
            this.mActive = false;
        }
        this.mIndex = 0;
    }

    private void getNodeBlock(Node node) {
        this.mBlock = XMLUtilities.xmlDOMToString(node).getBytes();
    }
}

