/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.common;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;

public class BinaryLob
implements Blob {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2005. (c) University of Edinburgh 2002 - 2005.";
    protected byte[] mByteArray = null;

    public long length() throws SQLException {
        if (this.mByteArray == null) {
            throw new SQLException("There is no BLOB data");
        }
        return this.mByteArray.length;
    }

    public byte[] getBytes(long pos, int length) throws SQLException {
        if (this.mByteArray == null) {
            throw new SQLException("There is no BLOB data");
        }
        int len = this.mByteArray.length;
        if (pos < 1L || pos > (long)len) {
            throw new IllegalArgumentException("Position must be > 0 and <= number of bytes");
        }
        if (length > len) {
            throw new IllegalArgumentException("Length must be <= number of bytes");
        }
        if (pos + (long)length > (long)len) {
            throw new IllegalArgumentException("Position + length must be <= number of bytes");
        }
        byte[] b = new byte[length];
        System.arraycopy(this.mByteArray, (int)pos - 1, b, 0, length);
        return b;
    }

    public InputStream getBinaryStream() throws SQLException {
        if (this.mByteArray == null) {
            throw new SQLException("There is no BLOB data");
        }
        return new ByteArrayInputStream(this.mByteArray);
    }

    public int setBytes(long pos, byte[] bytes) throws SQLException {
        return this.setBytes(pos, bytes, 0, bytes.length);
    }

    public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        if (this.mByteArray == null) {
            this.mByteArray = new byte[(int)pos - 1 + len];
        }
        if (pos - 1L + (long)len > (long)this.mByteArray.length) {
            byte[] temp = this.mByteArray;
            this.mByteArray = new byte[(int)pos - 1 + len];
            System.arraycopy(temp, 0, this.mByteArray, 0, temp.length);
        }
        System.arraycopy(bytes, offset, this.mByteArray, (int)pos - 1, len);
        return len;
    }

    public OutputStream setBinaryStream(long pos) throws SQLException {
        throw new UnsupportedOperationException("setBinaryStream");
    }

    public long position(byte[] pattern, long start) throws SQLException {
        throw new UnsupportedOperationException("position");
    }

    public long position(Blob pattern, long start) throws SQLException {
        throw new UnsupportedOperationException("position");
    }

    public void truncate(long len) throws SQLException {
        if (this.mByteArray == null) {
            throw new SQLException("There is no BLOB data");
        }
        if (len < (long)this.mByteArray.length) {
            byte[] temp = new byte[(int)len];
            System.arraycopy(this.mByteArray, 0, temp, 0, (int)len);
            this.mByteArray = temp;
        }
    }
}

