/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.common;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import uk.org.ogsadai.common.Base64;
import uk.org.ogsadai.common.MemoryUtilities;
import uk.org.ogsadai.common.OutOfMemoryException;
import uk.org.ogsadai.common.ReaderClosedException;
import uk.org.ogsadai.common.msgs.DAILogger;

public class Base64Reader
extends Reader {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2005. (c) University of Edinburgh 2002 - 2005.";
    private static final DAILogger LOG = DAILogger.getLogger(Base64Reader.class);
    private static final int BUFFER_SIZE = 12288;
    private final InputStream mInputStream;
    private byte[] mByteBuffer;
    private char[] mBase64Data;
    private boolean mEncoded = true;
    private int mRemaining;
    private boolean mClosed;

    public Base64Reader(InputStream input) throws IllegalArgumentException, OutOfMemoryException {
        if (input == null) {
            throw new IllegalArgumentException("input must not be null");
        }
        this.mInputStream = input;
        MemoryUtilities.checkMemory(12288, LOG);
        this.mByteBuffer = new byte[12288];
    }

    public int read(char[] cbuf, int off, int len) throws IOException, IllegalArgumentException {
        if (this.mClosed) {
            ReaderClosedException ex = new ReaderClosedException();
            IOException ioex = new IOException(ex.getLocalizedMessage());
            ioex.initCause(ex);
            throw ioex;
        }
        if (cbuf == null) {
            throw new IllegalArgumentException("cbuf must not be null");
        }
        if (len < 1) {
            throw new IllegalArgumentException("len must be >= 1");
        }
        if (off < 0 || off > cbuf.length - 1) {
            throw new IllegalArgumentException("off must be >= 0 and < cbuf " + cbuf.length);
        }
        if (off + len > cbuf.length) {
            throw new IllegalArgumentException("cbuf " + cbuf.length + " is too small to store len " + len + " bytes from offset " + off);
        }
        if (this.mBase64Data == null) {
            this.readAndEncode();
        }
        if (this.mEncoded) {
            int length = this.mRemaining > len ? len : this.mRemaining;
            System.arraycopy(this.mBase64Data, this.mBase64Data.length - this.mRemaining, cbuf, off, length);
            this.mRemaining -= length;
            if (this.mRemaining == 0) {
                this.readAndEncode();
            }
            return length;
        }
        return -1;
    }

    private void readAndEncode() throws IOException {
        int length = this.mInputStream.read(this.mByteBuffer);
        if (length == -1) {
            this.mEncoded = false;
        } else {
            this.mBase64Data = null;
            this.mBase64Data = new Base64().encode(this.mByteBuffer, 0, length);
            this.mRemaining = this.mBase64Data.length;
        }
    }

    public void close() {
        this.mByteBuffer = null;
        this.mBase64Data = null;
        this.mClosed = true;
    }

    public String readAll() throws IOException, OutOfMemoryException {
        int length;
        StringBuffer base64 = new StringBuffer();
        char[] buffer = new char[12288];
        while ((length = this.read(buffer, 0, buffer.length)) != -1) {
            MemoryUtilities.checkMemory(length, LOG);
            base64.append(buffer, 0, length);
        }
        return base64.toString();
    }
}

