/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.common;

import java.io.IOException;
import java.io.InputStream;
import uk.org.ogsadai.common.Base64;
import uk.org.ogsadai.common.MemoryUtilities;
import uk.org.ogsadai.common.OutOfMemoryException;
import uk.org.ogsadai.common.msgs.DAILogger;

public class Base64InputStream {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2005. (c) University of Edinburgh 2002 - 2005.";
    private static DAILogger LOG = DAILogger.getLogger(Base64InputStream.class);
    private static final int BASE64_BUFFER_SIZE = 12288;
    private InputStream mInputStream;
    private byte[] mBuffer = null;
    private byte[] mEncoded = null;
    private int mStreamIndex = 0;
    private boolean mStreamHasData = false;

    public Base64InputStream(InputStream in) throws OutOfMemoryException {
        this.mInputStream = in;
        MemoryUtilities.checkMemory(12288, LOG);
        this.mBuffer = new byte[12288];
    }

    public int available() throws IOException, OutOfMemoryException {
        if (!this.mStreamHasData) {
            this.readAndEncode();
        }
        if (!this.mStreamHasData) {
            return 0;
        }
        return this.mEncoded.length - this.mStreamIndex;
    }

    public int read(byte[] b) throws IOException, OutOfMemoryException {
        int remainingLen;
        int copyLength = 0;
        if (!this.mStreamHasData) {
            this.readAndEncode();
        }
        int n = copyLength = b.length < (remainingLen = this.mEncoded.length - this.mStreamIndex) ? b.length : remainingLen;
        if (copyLength == 0) {
            return -1;
        }
        System.arraycopy(this.mEncoded, this.mStreamIndex, b, 0, copyLength);
        this.mStreamIndex += copyLength;
        if (this.mStreamIndex == this.mEncoded.length) {
            this.mStreamHasData = false;
        }
        if (copyLength == 0) {
            return -1;
        }
        return copyLength;
    }

    private void readAndEncode() throws IOException, OutOfMemoryException {
        int bytesLeft = this.mInputStream.available();
        if (bytesLeft == 0) {
            this.mStreamHasData = false;
            return;
        }
        if (bytesLeft < 12288) {
            MemoryUtilities.checkMemory(bytesLeft, LOG);
            this.mBuffer = null;
            this.mBuffer = new byte[bytesLeft];
        }
        this.mInputStream.read(this.mBuffer);
        MemoryUtilities.checkMemory(this.mBuffer.length * 4 / 3, LOG);
        this.mEncoded = new Base64().encode(this.mBuffer);
        this.mStreamIndex = 0;
        this.mStreamHasData = true;
    }

    public void close() throws IOException {
        this.mEncoded = null;
        this.mBuffer = null;
        this.mInputStream.close();
        this.mInputStream = null;
    }
}

