/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.toolkit.wsrf;

import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import org.apache.axis.AxisFault;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.SOAPBodyElement;
import org.apache.axis.message.addressing.AddressingHeaders;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import uk.org.ogsadai.client.toolkit.ConnectionProperty;
import uk.org.ogsadai.client.toolkit.Request;
import uk.org.ogsadai.client.toolkit.ResourceID;
import uk.org.ogsadai.client.toolkit.Response;
import uk.org.ogsadai.client.toolkit.SimpleResourceIDImpl;
import uk.org.ogsadai.client.toolkit.activity.ActivityRequest;
import uk.org.ogsadai.client.toolkit.activity.RequestComponent;
import uk.org.ogsadai.client.toolkit.exception.AuthorisationException;
import uk.org.ogsadai.client.toolkit.exception.DataFormatException;
import uk.org.ogsadai.client.toolkit.exception.DeserializationException;
import uk.org.ogsadai.client.toolkit.exception.FaultToException;
import uk.org.ogsadai.client.toolkit.exception.RequestException;
import uk.org.ogsadai.client.toolkit.exception.ResourceBusyException;
import uk.org.ogsadai.client.toolkit.exception.ResourcePropertyException;
import uk.org.ogsadai.client.toolkit.exception.ResourceUnknownException;
import uk.org.ogsadai.client.toolkit.exception.ResponseDocumentException;
import uk.org.ogsadai.client.toolkit.exception.ServerException;
import uk.org.ogsadai.client.toolkit.exception.ServiceCommsException;
import uk.org.ogsadai.client.toolkit.properties.ActivityMetaData;
import uk.org.ogsadai.client.toolkit.properties.DAIVersion;
import uk.org.ogsadai.client.toolkit.properties.DataResourceInfo;
import uk.org.ogsadai.client.toolkit.properties.Property;
import uk.org.ogsadai.client.toolkit.properties.RequestStatus;
import uk.org.ogsadai.client.toolkit.properties.RequestStatusException;
import uk.org.ogsadai.client.toolkit.properties.SimplePropertyImpl;
import uk.org.ogsadai.client.toolkit.properties.UnknownPropertyException;
import uk.org.ogsadai.client.toolkit.service.DataService;
import uk.org.ogsadai.client.toolkit.service.DataTransport;
import uk.org.ogsadai.client.toolkit.service.SOAPCallFactory;
import uk.org.ogsadai.client.toolkit.service.ServiceConstants;
import uk.org.ogsadai.client.toolkit.service.SimpleSOAPCallFactory;
import uk.org.ogsadai.client.toolkit.service.faults.AuthorisationFaultType;
import uk.org.ogsadai.client.toolkit.service.faults.InternalFaultType;
import uk.org.ogsadai.client.toolkit.service.faults.RequestFaultType;
import uk.org.ogsadai.client.toolkit.service.faults.ResourceBusyFaultType;
import uk.org.ogsadai.client.toolkit.service.faults.ResourceUnknownFaultType;
import uk.org.ogsadai.client.toolkit.service.faults.wsrp.InvalidResourcePropertyQNameFaultType;
import uk.org.ogsadai.client.toolkit.sessions.JoinNewSession;
import uk.org.ogsadai.client.toolkit.sessions.Session;
import uk.org.ogsadai.client.toolkit.sessions.SessionID;
import uk.org.ogsadai.client.toolkit.sessions.SessionNames;
import uk.org.ogsadai.client.toolkit.sessions.SessionStreamID;
import uk.org.ogsadai.client.toolkit.sessions.TerminateSession;
import uk.org.ogsadai.client.toolkit.soap.AttachmentManager;
import uk.org.ogsadai.client.toolkit.soap.CTkSOAPException;
import uk.org.ogsadai.client.toolkit.soap.SOAPCall;
import uk.org.ogsadai.client.toolkit.wsrf.AddressingUtils;
import uk.org.ogsadai.client.toolkit.wsrf.WSRFDataTransport;
import uk.org.ogsadai.common.xml.XMLUtilities;

public class WSRFDataService
implements DataService {
    private static final String COPYRIGHT_NOTICE = "(c) University of Edinburgh 2002 - 2006.";
    private final URL mServiceURL;
    protected ResourceID mResourceID;
    private final WSRFDataTransport mTransport;
    private final SOAPCallFactory mCallFactory = new SimpleSOAPCallFactory();

    public WSRFDataService(String url) throws MalformedURLException {
        this(url, null);
    }

    public WSRFDataService(String url, ResourceID resourceID) throws MalformedURLException {
        this.mServiceURL = new URL(url);
        this.mResourceID = resourceID;
        this.mTransport = new WSRFDataTransport(this.mServiceURL, resourceID, this.mCallFactory);
    }

    public DAIVersion getVersion() throws ServerException, ServiceCommsException {
        Vector response = this.invokeServiceOperation(ServiceConstants.GET_VERSION_OP);
        QName resultName = new QName("http://ogsadai.org.uk/namespaces/2005/10/service/types", "version");
        String version = this.getStringFromResponse(response, resultName);
        return new DAIVersion(version);
    }

    public ResourceID[] getResourceIDs() throws ServerException, ServiceCommsException {
        Vector response = this.invokeServiceOperation(ServiceConstants.LIST_RESOURCES_OP);
        QName resultName = new QName("http://ogsadai.org.uk/namespaces/2005/10/service/types", "resource");
        String[] resourceNames = this.getStringsFromResponse(response, resultName);
        ResourceID[] resourceIDs = new ResourceID[resourceNames.length];
        for (int i = 0; i < resourceIDs.length; ++i) {
            resourceIDs[i] = new SimpleResourceIDImpl(resourceNames[i]);
        }
        return resourceIDs;
    }

    public RequestStatus getStatus(SessionID sessionID) throws ServiceCommsException, UnknownPropertyException, ResourceUnknownException, ServerException, AuthorisationException {
        QName name = SessionNames.createStatusResourcePropertyName(sessionID);
        Property property = this.getProperty(name);
        RequestStatus status = null;
        try {
            status = RequestStatus.createFromProperty(property);
        }
        catch (DataFormatException e) {
            throw new ResourcePropertyException(name, (Throwable)e);
        }
        return status;
    }

    public DataResourceInfo getDataResourceInfo() throws ServiceCommsException, UnknownPropertyException, ResourceUnknownException, ServerException, AuthorisationException {
        Property property = this.getProperty(ServiceConstants.PRODUCT_INFO);
        DataResourceInfo info = null;
        try {
            info = DataResourceInfo.createFromProperty(property);
        }
        catch (DataFormatException e) {
            throw new ResourcePropertyException(ServiceConstants.PRODUCT_INFO, (Throwable)e);
        }
        return info;
    }

    public String[] getSupportedActivities() throws ServiceCommsException, UnknownPropertyException, ResourceUnknownException, ServerException, AuthorisationException {
        Property property = this.getProperty(ServiceConstants.ACTIVITIES);
        ActivityMetaData[] metadata = null;
        try {
            metadata = ActivityMetaData.createFromProperty(property);
        }
        catch (DataFormatException e) {
            throw new ResourcePropertyException(ServiceConstants.ACTIVITIES, (Throwable)e);
        }
        int numActivities = metadata.length;
        String[] activities = new String[numActivities];
        for (int i = 0; i < numActivities; ++i) {
            activities[i] = metadata[i].getName();
        }
        return activities;
    }

    public ActivityMetaData getActivityMetaData(String activityName) throws ServiceCommsException, UnknownPropertyException, ResourceUnknownException, ServerException, AuthorisationException {
        if (activityName == null) {
            throw new IllegalArgumentException("activityName must not be null");
        }
        ActivityMetaData result = null;
        Property property = this.getProperty(ServiceConstants.ACTIVITIES);
        try {
            ActivityMetaData[] metadata = ActivityMetaData.createFromProperty(property);
            for (int i = 0; i < metadata.length; ++i) {
                if (!metadata[i].getName().equals(activityName)) continue;
                result = metadata[i];
            }
        }
        catch (DataFormatException e) {
            throw new ResourcePropertyException(ServiceConstants.ACTIVITIES, (Throwable)e);
        }
        return result;
    }

    public Property getProperty(QName propertyName) throws ServiceCommsException, UnknownPropertyException, ResourceUnknownException, ServerException, AuthorisationException {
        QName operationName = ServiceConstants.GET_PROPERTY_OP_WSRF;
        Vector resultVector = this.invokeServiceResourceOperation(this.mResourceID, operationName, new SOAPBodyElement(operationName, (Object)propertyName));
        SimplePropertyImpl property = null;
        try {
            int numResults = resultVector.size();
            for (int i = 0; i < numResults; ++i) {
                SOAPBodyElement el = (SOAPBodyElement)resultVector.get(i);
                List propertyNodes = XMLUtilities.getChildElements((Element)el);
                if (propertyNodes == null || propertyNodes.size() <= 0) continue;
                int numValues = propertyNodes.size();
                try {
                    if (numValues == 1) {
                        MessageElement msg = (MessageElement)propertyNodes.get(0);
                        property = new SimplePropertyImpl(msg.getQName(), msg.getAsDOM());
                    } else {
                        MessageElement msg = (MessageElement)propertyNodes.get(0);
                        Element[] values = new Element[numValues];
                        for (int j = 0; j < numValues; ++j) {
                            values[j] = ((MessageElement)propertyNodes.get(j)).getAsDOM();
                        }
                        property = new SimplePropertyImpl(msg.getQName(), values);
                    }
                    break;
                }
                catch (Exception e) {
                    throw new DeserializationException(e);
                }
            }
        }
        catch (Exception e) {
            throw new ResourcePropertyException(propertyName, (Throwable)e);
        }
        return property;
    }

    public Property[] getProperties(QName[] names) throws ServiceCommsException, UnknownPropertyException, ResourceUnknownException, ServerException, AuthorisationException {
        QName operationName = ServiceConstants.GET_PROPERTIES_OP_WSRF;
        SOAPBodyElement body = new SOAPBodyElement(operationName);
        try {
            for (int i = 0; i < names.length; ++i) {
                SOAPBodyElement qname = new SOAPBodyElement(ServiceConstants.GET_PROPERTIES_REQUEST_QNAME_WSRF, (Object)names[i]);
                body.addChildElement((SOAPElement)qname);
            }
        }
        catch (SOAPException e) {
            throw new CTkSOAPException(e);
        }
        Vector responseVector = this.invokeServiceResourceOperation(this.mResourceID, operationName, body);
        Property[] properties = null;
        try {
            int numResults = responseVector.size();
            for (int i = 0; i < numResults; ++i) {
                SOAPBodyElement el = (SOAPBodyElement)responseVector.get(i);
                List valueNodes = XMLUtilities.getChildElements((Element)el);
                HashMap<QName, Vector> propertiesMap = new HashMap<QName, Vector>();
                if (valueNodes == null || valueNodes.size() <= 0) continue;
                int numValues = valueNodes.size();
                for (int j = 0; j < numValues; ++j) {
                    Vector propertyValues;
                    Element msg;
                    try {
                        msg = ((MessageElement)valueNodes.get(j)).getAsDOM();
                    }
                    catch (Exception e) {
                        throw new DeserializationException(e);
                    }
                    QName name = new QName(msg.getNamespaceURI(), msg.getLocalName());
                    if (propertiesMap.containsKey(name)) {
                        propertyValues = (Vector)propertiesMap.get(name);
                        propertyValues.add(msg);
                        continue;
                    }
                    propertyValues = new Vector();
                    propertyValues.add(msg);
                    propertiesMap.put(name, propertyValues);
                }
                Object[] propertyNames = propertiesMap.keySet().toArray();
                int numProperties = propertyNames.length;
                properties = new Property[numProperties];
                for (int j = 0; j < numProperties; ++j) {
                    QName name = (QName)propertyNames[j];
                    Vector values = (Vector)propertiesMap.get(name);
                    properties[j] = values.size() > 1 ? new SimplePropertyImpl(name, values.toArray(new Element[0])) : new SimplePropertyImpl(name, values.get(0));
                }
                break;
            }
        }
        catch (Exception e) {
            throw new ResourcePropertyException(e);
        }
        return properties;
    }

    public Response perform(Request request) throws ServerException, AuthorisationException, RequestException, ResourceUnknownException, ResourceBusyException, ServiceCommsException {
        request.setDataResourceID(this.mResourceID);
        request.setDataService(this);
        Document performDoc = request.getDocument();
        QName operationName = ServiceConstants.PERFORM_OP;
        SOAPBodyElement body = new SOAPBodyElement(operationName);
        try {
            MessageElement performWrapper = new MessageElement(ServiceConstants.PERFORM_DOC_QNAME);
            MessageElement perform = new MessageElement(performDoc.getDocumentElement());
            body.addChildElement((SOAPElement)performWrapper);
            performWrapper.addChildElement((SOAPElement)perform);
        }
        catch (SOAPException e) {
            throw new CTkSOAPException(e);
        }
        SOAPCall call = this.mCallFactory.createSOAPCall();
        this.addAddressingHeaders(call, this.mResourceID);
        Vector resultVector = null;
        AttachmentManager attachmentManager = null;
        try {
            resultVector = call.invoke(this.mServiceURL.toString(), operationName, body);
            attachmentManager = call.getAttachmentManager();
        }
        catch (RequestFaultType e) {
            throw FaultToException.getRequestException(e);
        }
        catch (ResourceUnknownFaultType e) {
            throw FaultToException.getResourceUnknownException(e);
        }
        catch (ResourceBusyFaultType e) {
            throw FaultToException.getResourceBusyException(e);
        }
        catch (InternalFaultType e) {
            throw FaultToException.getServerException(e);
        }
        catch (AuthorisationFaultType e) {
            throw FaultToException.getAuthorisationException(e);
        }
        catch (AxisFault e) {
            SOAPCall.checkUnsupportedOperation(this.mServiceURL.toString(), ServiceConstants.PERFORM_OP, e);
        }
        catch (RemoteException e) {
            throw new ServiceCommsException(this.mServiceURL.toString(), e);
        }
        Response response = null;
        try {
            SOAPBodyElement element = (SOAPBodyElement)resultVector.get(0);
            NodeList nodes = element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "response");
            Document document = ((MessageElement)nodes.item(0)).getAsDocument();
            response = request.createResponse(document, attachmentManager);
        }
        catch (Exception e) {
            throw new ResponseDocumentException(e);
        }
        return response;
    }

    public void terminate() throws ServerException, AuthorisationException, ResourceUnknownException, ResourceBusyException, ServiceCommsException {
        QName op = ServiceConstants.TERMINATE_OP;
        SOAPBodyElement body = new SOAPBodyElement(op);
        SOAPCall call = this.mCallFactory.createSOAPCall();
        this.addAddressingHeaders(call, this.mResourceID);
        Vector resultVector = null;
        try {
            resultVector = call.invoke(this.mServiceURL.toString(), op, body);
        }
        catch (ResourceUnknownFaultType e) {
            throw FaultToException.getResourceUnknownException(e);
        }
        catch (ResourceBusyFaultType e) {
            throw FaultToException.getResourceBusyException(e);
        }
        catch (InternalFaultType e) {
            throw FaultToException.getServerException(e);
        }
        catch (AuthorisationFaultType e) {
            throw FaultToException.getAuthorisationException(e);
        }
        catch (AxisFault e) {
            SOAPCall.checkUnsupportedOperation(this.mServiceURL.toString(), ServiceConstants.TERMINATE_OP, e);
        }
        catch (RemoteException e) {
            throw new ServiceCommsException(this.mServiceURL.toString(), e);
        }
    }

    public void pollUntilRequestCompleted(SessionID sessionID, int pollInterval) throws ServiceCommsException, UnknownPropertyException, ResourceUnknownException, ServerException, AuthorisationException, RequestStatusException, IllegalArgumentException {
        this.pollUntilRequestCompleted(sessionID, pollInterval, 1, true);
    }

    public void pollUntilRequestCompleted(SessionID sessionID, int pollInterval, int timeoutPeriod) throws ServiceCommsException, UnknownPropertyException, ResourceUnknownException, ServerException, AuthorisationException, RequestStatusException, IllegalArgumentException {
        this.pollUntilRequestCompleted(sessionID, pollInterval, timeoutPeriod, false);
    }

    public void pollUntilRequestCompleted(SessionID sessionID, int pollInterval, int timeoutPeriod, boolean forever) throws ServiceCommsException, UnknownPropertyException, ResourceUnknownException, ServerException, AuthorisationException, RequestStatusException, IllegalArgumentException {
        if (pollInterval <= 0) {
            throw new IllegalArgumentException("pollInterval must be > 0 : " + pollInterval);
        }
        if (timeoutPeriod <= 0) {
            throw new IllegalArgumentException("timeoutPeriod must be > 0 : " + timeoutPeriod);
        }
        int numPolls = timeoutPeriod / pollInterval + 1;
        RequestStatus status = null;
        boolean completed = false;
        for (int i = 0; (forever || i < numPolls) && !completed; ++i) {
            status = this.getStatus(sessionID);
            if (status == RequestStatus.COMPLETED) {
                completed = true;
            } else {
                if (status == RequestStatus.ERROR || status == RequestStatus.TERMINATED || status == RequestStatus.TIMEDOUT) {
                    throw new RequestStatusException(status);
                }
                try {
                    Thread.sleep(pollInterval);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            if (!forever) continue;
            i = 0;
        }
        if (!completed) {
            throw new RequestStatusException(status);
        }
    }

    public URL getURL() {
        return this.mServiceURL;
    }

    public void setTimeout(int duration) {
        this.mCallFactory.setDefaultTimeout(duration);
    }

    public void setProperty(String name, Object value) {
        this.mCallFactory.setDefaultProperty(name, value);
    }

    public Response perform(RequestComponent component) throws ServerException, AuthorisationException, RequestException, ResourceUnknownException, ResourceBusyException, ServiceCommsException {
        ActivityRequest request = new ActivityRequest();
        request.add(component);
        request.setDataService(this);
        return this.perform(request);
    }

    public Session createSession() throws ServerException, AuthorisationException, RequestException, ResourceUnknownException, ResourceBusyException, ServiceCommsException {
        ActivityRequest request = new ActivityRequest();
        request.setSessionRequirements(new JoinNewSession());
        Response response = this.perform(request);
        return response.getSession();
    }

    public void closeSession(Session session) throws ServerException, AuthorisationException, RequestException, ResourceUnknownException, ResourceBusyException, ServiceCommsException {
        ActivityRequest request = new ActivityRequest();
        request.setSessionRequirements(new TerminateSession(session));
        this.perform(request);
    }

    public DataTransport createDataTransport(ResourceID resourceID, SessionStreamID stream) {
        SOAPCallFactory factory = (SOAPCallFactory)this.mCallFactory.clone();
        return new WSRFDataTransport(this.getURL(), resourceID, stream, factory);
    }

    public void setResourceID(ResourceID id) {
        this.mResourceID = id;
        this.mTransport.setResourceID(id);
    }

    public void setConnectionProperty(ConnectionProperty property) {
        property.configureCallFactory(this.mCallFactory);
    }

    public void ping() throws ServiceCommsException {
        try {
            this.getVersion();
        }
        catch (ServerException serverException) {
            // empty catch block
        }
    }

    public Object getFully() throws ServerException, AuthorisationException, RequestException, ResourceUnknownException, ResourceBusyException, ServiceCommsException {
        return this.mTransport.getFully();
    }

    public Object getNBlocks(int numberOfBlocks) throws ServerException, AuthorisationException, RequestException, ResourceUnknownException, ResourceBusyException, ServiceCommsException {
        return this.mTransport.getNBlocks(numberOfBlocks);
    }

    public Object getBlock() throws ServerException, AuthorisationException, RequestException, ResourceUnknownException, ResourceBusyException, ServiceCommsException {
        return this.mTransport.getBlock();
    }

    public void putFully(Object data) throws ServerException, AuthorisationException, RequestException, ResourceUnknownException, ResourceBusyException, ServiceCommsException {
        this.mTransport.putFully(data);
    }

    public void putBlock(Object data) throws ServerException, AuthorisationException, RequestException, ResourceUnknownException, ResourceBusyException, ServiceCommsException {
        this.mTransport.putBlock(data);
    }

    public void putClosingBlock() throws ServerException, AuthorisationException, RequestException, ResourceUnknownException, ResourceBusyException, ServiceCommsException {
        this.mTransport.putClosingBlock();
    }

    public URL getDataTransportURL() {
        return this.mTransport.getDataTransportURL();
    }

    public SessionStreamID getSessionStreamID() {
        return this.mTransport.getSessionStreamID();
    }

    public void setSessionStreamID(SessionStreamID streamID) {
        this.mTransport.setSessionStreamID(streamID);
    }

    public ResourceID getResourceID() {
        return this.mResourceID;
    }

    protected SOAPCallFactory getCallFactory() {
        return this.mCallFactory;
    }

    protected void addAddressingHeaders(SOAPCall call, ResourceID resourceID) throws ServiceCommsException {
        try {
            AddressingHeaders headers = AddressingUtils.generateHeaders(this.mServiceURL, resourceID);
            call.getCall().setProperty("org.apache.axis.message.addressing.REQUEST.HEADERS", (Object)headers);
        }
        catch (MalformedURLException e) {
            throw new ServiceCommsException(this.mServiceURL.toString(), e);
        }
    }

    private Vector invokeServiceOperation(QName operationName) throws ServerException, ServiceCommsException {
        return this.invokeServiceOperation(operationName, new SOAPBodyElement(operationName));
    }

    private Vector invokeServiceOperation(QName operationName, SOAPBodyElement body) throws ServerException, ServiceCommsException {
        Vector resultVector = null;
        try {
            SOAPCall call = this.mCallFactory.createSOAPCall();
            resultVector = call.invoke(this.mServiceURL.toString(), operationName, body);
        }
        catch (InternalFaultType e) {
            throw FaultToException.getServerException(e);
        }
        catch (AxisFault e) {
            SOAPCall.checkUnsupportedOperation(this.mServiceURL.toString(), operationName, e);
        }
        catch (RemoteException e) {
            throw new ServiceCommsException(this.mServiceURL.toString(), e);
        }
        return resultVector;
    }

    private Vector invokeServiceResourceOperation(ResourceID resourceID, QName operationName, SOAPBodyElement body) throws ServiceCommsException, UnknownPropertyException, ResourceUnknownException, ServerException, AuthorisationException {
        Vector result = null;
        SOAPCall call = this.mCallFactory.createSOAPCall();
        this.addAddressingHeaders(call, resourceID);
        try {
            result = call.invoke(this.mServiceURL.toString(), operationName, body);
        }
        catch (InvalidResourcePropertyQNameFaultType e) {
            throw FaultToException.getUnknownPropertyException(e);
        }
        catch (uk.org.ogsadai.client.toolkit.service.faults.wsrp.ResourceUnknownFaultType e) {
            throw FaultToException.getResourceUnknownException(e);
        }
        catch (InternalFaultType e) {
            throw FaultToException.getServerException(e);
        }
        catch (AuthorisationFaultType e) {
            throw FaultToException.getAuthorisationException(e);
        }
        catch (AxisFault e) {
            SOAPCall.checkUnsupportedOperation(this.mServiceURL.toString(), operationName, e);
        }
        catch (RemoteException e) {
            throw new ServiceCommsException(this.mServiceURL.toString(), e);
        }
        return result;
    }

    private String getStringFromResponse(List response, QName resultName) {
        String[] results = this.getStringsFromResponse(response, resultName);
        return results == null || results.length == 0 ? null : results[0];
    }

    private String[] getStringsFromResponse(List response, QName resultName) {
        ArrayList<String> results = new ArrayList<String>(response.size());
        try {
            for (int i = 0; i < response.size(); ++i) {
                SOAPBodyElement element = (SOAPBodyElement)response.get(i);
                NodeList nodes = element.getElementsByTagNameNS(resultName.getNamespaceURI(), resultName.getLocalPart());
                if (nodes == null || nodes.getLength() <= 0) continue;
                for (int j = 0; j < nodes.getLength(); ++j) {
                    String result = nodes.item(j).getFirstChild().getNodeValue();
                    results.add(result);
                }
                break;
            }
        }
        catch (Exception e) {
            throw new DeserializationException(e);
        }
        return results.toArray(new String[results.size()]);
    }
}

