/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.toolkit.wsi;

import java.net.URL;
import java.rmi.RemoteException;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import org.apache.axis.AxisFault;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.SOAPBodyElement;
import org.w3c.dom.NodeList;
import uk.org.ogsadai.client.toolkit.ConnectionProperty;
import uk.org.ogsadai.client.toolkit.ResourceID;
import uk.org.ogsadai.client.toolkit.exception.AuthorisationException;
import uk.org.ogsadai.client.toolkit.exception.DeserializationException;
import uk.org.ogsadai.client.toolkit.exception.FaultToException;
import uk.org.ogsadai.client.toolkit.exception.RequestException;
import uk.org.ogsadai.client.toolkit.exception.ResourceBusyException;
import uk.org.ogsadai.client.toolkit.exception.ResourceUnknownException;
import uk.org.ogsadai.client.toolkit.exception.ServerException;
import uk.org.ogsadai.client.toolkit.exception.ServiceCommsException;
import uk.org.ogsadai.client.toolkit.service.DataTransport;
import uk.org.ogsadai.client.toolkit.service.SOAPCallFactory;
import uk.org.ogsadai.client.toolkit.service.ServiceConstants;
import uk.org.ogsadai.client.toolkit.service.faults.AuthorisationFaultType;
import uk.org.ogsadai.client.toolkit.service.faults.InternalFaultType;
import uk.org.ogsadai.client.toolkit.service.faults.RequestFaultType;
import uk.org.ogsadai.client.toolkit.service.faults.ResourceBusyFaultType;
import uk.org.ogsadai.client.toolkit.service.faults.ResourceUnknownFaultType;
import uk.org.ogsadai.client.toolkit.sessions.SessionStreamID;
import uk.org.ogsadai.client.toolkit.soap.CTkSOAPException;
import uk.org.ogsadai.client.toolkit.soap.SOAPCall;
import uk.org.ogsadai.common.serializer.SerializerUtils;

public class WSIDataTransport
implements DataTransport {
    private static final String COPYRIGHT_NOTICE = "(c) University of Edinburgh 2002 - 2006.";
    private URL mServiceURL;
    private SessionStreamID mSessionStreamID;
    private ResourceID mResourceID;
    private final SOAPCallFactory mCallFactory;

    public WSIDataTransport(URL serviceURL, SOAPCallFactory callFactory) throws IllegalArgumentException {
        if (serviceURL == null) {
            throw new IllegalArgumentException("The serviceURL paramter must not be null");
        }
        this.mServiceURL = serviceURL;
        this.mCallFactory = callFactory;
    }

    public WSIDataTransport(URL url, ResourceID id, SOAPCallFactory callFactory) throws IllegalArgumentException {
        this.mServiceURL = url;
        this.mCallFactory = callFactory;
        this.setResourceID(id);
    }

    public WSIDataTransport(URL url, ResourceID resourceID, SessionStreamID sessionStreamID, SOAPCallFactory factory) throws IllegalArgumentException {
        this.mServiceURL = url;
        this.mCallFactory = factory;
        this.setResourceID(resourceID);
        this.setSessionStreamID(sessionStreamID);
    }

    public void setSessionStreamID(SessionStreamID sessionStreamID) throws IllegalArgumentException {
        if (sessionStreamID == null) {
            throw new IllegalArgumentException("sessionStreamID must not be null");
        }
        this.mSessionStreamID = sessionStreamID;
    }

    public SessionStreamID getSessionStreamID() {
        return this.mSessionStreamID;
    }

    public void setResourceID(ResourceID id) throws IllegalArgumentException {
        if (id == null) {
            throw new IllegalArgumentException("id must not be null");
        }
        this.mResourceID = id;
    }

    public ResourceID getResourceID() {
        return this.mResourceID;
    }

    public URL getDataTransportURL() {
        return this.mServiceURL;
    }

    public Object getFully() throws ServerException, AuthorisationException, RequestException, ResourceUnknownException, ResourceBusyException, ServiceCommsException {
        String target = this.getServiceURL();
        QName operationName = ServiceConstants.TRANSPORT_GET_FULLY_OP;
        SOAPBodyElement body = new SOAPBodyElement(operationName);
        try {
            SOAPBodyElement stream = new SOAPBodyElement(ServiceConstants.TRANSPORT_STREAM_ID_QNAME, (Object)this.mSessionStreamID.getCompoundID());
            body.addChild((MessageElement)stream);
        }
        catch (SOAPException e) {
            throw new CTkSOAPException(e);
        }
        Vector responseVec = null;
        try {
            SOAPCall call = this.mCallFactory.createSOAPCall();
            responseVec = call.invoke(target, operationName, body);
        }
        catch (RequestFaultType e) {
            throw FaultToException.getRequestException(e);
        }
        catch (ResourceUnknownFaultType e) {
            throw FaultToException.getResourceUnknownException(e);
        }
        catch (ResourceBusyFaultType e) {
            throw FaultToException.getResourceBusyException(e);
        }
        catch (InternalFaultType e) {
            throw FaultToException.getServerException(e);
        }
        catch (AuthorisationFaultType e) {
            throw FaultToException.getAuthorisationException(e);
        }
        catch (AxisFault e) {
            SOAPCall.checkUnsupportedOperation(this.mServiceURL.toString(), operationName, e);
        }
        catch (RemoteException e) {
            throw new ServiceCommsException(this.mServiceURL.toString(), e);
        }
        Object data = null;
        try {
            SOAPBodyElement element;
            NodeList children;
            if (responseVec != null && responseVec.size() > 0 && (children = (element = (SOAPBodyElement)responseVec.get(0)).getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/service/transport/types", "result")).getLength() > 0) {
                MessageElement result = (MessageElement)children.item(0);
                MessageElement msg = result.getChildElement(ServiceConstants.DATA_BLOCK_QNAME);
                data = SerializerUtils.toObject(msg);
            }
        }
        catch (Exception e) {
            throw new DeserializationException(e);
        }
        return data;
    }

    public Object getNBlocks(int numberOfBlocks) throws ServerException, AuthorisationException, RequestException, ResourceUnknownException, ResourceBusyException, ServiceCommsException {
        if (numberOfBlocks <= 0) {
            throw new IllegalArgumentException("numberOfBlocks must be > 0 : " + numberOfBlocks);
        }
        String target = this.getServiceURL();
        QName operationName = ServiceConstants.TRANSPORT_GET_N_BLOCKS_OP;
        SOAPBodyElement body = new SOAPBodyElement(operationName);
        try {
            SOAPBodyElement stream = new SOAPBodyElement(ServiceConstants.TRANSPORT_STREAM_ID_QNAME, (Object)this.mSessionStreamID.getCompoundID());
            body.addChild((MessageElement)stream);
            SOAPBodyElement blocks = new SOAPBodyElement(ServiceConstants.TRANSPORT_NUM_BLOCKS_QNAME, (Object)new Integer(numberOfBlocks));
            body.addChild((MessageElement)blocks);
        }
        catch (SOAPException e) {
            throw new CTkSOAPException(e);
        }
        Vector responseVec = null;
        try {
            SOAPCall call = this.mCallFactory.createSOAPCall();
            responseVec = call.invoke(target, operationName, body);
        }
        catch (RequestFaultType e) {
            throw FaultToException.getRequestException(e);
        }
        catch (ResourceUnknownFaultType e) {
            throw FaultToException.getResourceUnknownException(e);
        }
        catch (ResourceBusyFaultType e) {
            throw FaultToException.getResourceBusyException(e);
        }
        catch (InternalFaultType e) {
            throw FaultToException.getServerException(e);
        }
        catch (AuthorisationFaultType e) {
            throw FaultToException.getAuthorisationException(e);
        }
        catch (AxisFault e) {
            SOAPCall.checkUnsupportedOperation(this.mServiceURL.toString(), operationName, e);
        }
        catch (RemoteException e) {
            throw new ServiceCommsException(this.mServiceURL.toString(), e);
        }
        Object data = null;
        try {
            SOAPBodyElement element;
            NodeList children;
            if (responseVec != null && responseVec.size() > 0 && (children = (element = (SOAPBodyElement)responseVec.get(0)).getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/service/transport/types", "result")).getLength() > 0) {
                MessageElement result = (MessageElement)children.item(0);
                MessageElement msg = result.getChildElement(ServiceConstants.DATA_BLOCK_QNAME);
                data = SerializerUtils.toObject(msg);
            }
        }
        catch (Exception e) {
            throw new DeserializationException(e);
        }
        return data;
    }

    public Object getBlock() throws ServerException, AuthorisationException, RequestException, ResourceUnknownException, ResourceBusyException, ServiceCommsException {
        return this.getNBlocks(1);
    }

    public void putFully(Object data) throws ServerException, AuthorisationException, RequestException, ResourceUnknownException, ResourceBusyException, ServiceCommsException {
        String target = this.getServiceURL();
        QName operationName = ServiceConstants.TRANSPORT_PUT_FULLY_OP;
        SOAPBodyElement body = new SOAPBodyElement(operationName);
        try {
            SOAPBodyElement stream = new SOAPBodyElement(ServiceConstants.TRANSPORT_STREAM_ID_QNAME, (Object)this.mSessionStreamID.getCompoundID());
            body.addChild((MessageElement)stream);
            MessageElement[] msg = SerializerUtils.toMessage(ServiceConstants.DATA_BLOCK_QNAME, data);
            SOAPBodyElement dataMsg = new SOAPBodyElement(ServiceConstants.TRANSPORT_DATA_QNAME);
            if (msg != null) {
                int numElts = msg.length;
                for (int i = 0; i < numElts; ++i) {
                    dataMsg.addChild(msg[i]);
                }
            }
            body.addChild((MessageElement)dataMsg);
        }
        catch (SOAPException e) {
            throw new CTkSOAPException(e);
        }
        try {
            SOAPCall call = this.mCallFactory.createSOAPCall();
            call.invoke(target, operationName, body);
        }
        catch (RequestFaultType e) {
            throw FaultToException.getRequestException(e);
        }
        catch (ResourceUnknownFaultType e) {
            throw FaultToException.getResourceUnknownException(e);
        }
        catch (ResourceBusyFaultType e) {
            throw FaultToException.getResourceBusyException(e);
        }
        catch (InternalFaultType e) {
            throw FaultToException.getServerException(e);
        }
        catch (AuthorisationFaultType e) {
            throw FaultToException.getAuthorisationException(e);
        }
        catch (AxisFault e) {
            SOAPCall.checkUnsupportedOperation(this.mServiceURL.toString(), operationName, e);
        }
        catch (RemoteException e) {
            throw new ServiceCommsException(this.mServiceURL.toString(), e);
        }
    }

    public void putBlock(Object data) throws ServerException, AuthorisationException, RequestException, ResourceUnknownException, ResourceBusyException, ServiceCommsException {
        String target = this.getServiceURL();
        QName operationName = ServiceConstants.TRANSPORT_PUT_BLOCK_OP;
        SOAPBodyElement body = new SOAPBodyElement(operationName);
        try {
            SOAPBodyElement stream = new SOAPBodyElement(ServiceConstants.TRANSPORT_STREAM_ID_QNAME, (Object)this.mSessionStreamID.getCompoundID());
            body.addChild((MessageElement)stream);
            MessageElement[] msg = SerializerUtils.toMessage(ServiceConstants.DATA_BLOCK_QNAME, data);
            SOAPBodyElement dataMsg = new SOAPBodyElement(ServiceConstants.TRANSPORT_DATA_QNAME);
            if (msg != null) {
                int numElts = msg.length;
                for (int i = 0; i < numElts; ++i) {
                    dataMsg.addChild(msg[i]);
                }
            }
            body.addChild((MessageElement)dataMsg);
        }
        catch (SOAPException e) {
            throw new CTkSOAPException(e);
        }
        try {
            SOAPCall call = this.mCallFactory.createSOAPCall();
            call.invoke(target, operationName, body);
        }
        catch (RequestFaultType e) {
            throw FaultToException.getRequestException(e);
        }
        catch (ResourceUnknownFaultType e) {
            throw FaultToException.getResourceUnknownException(e);
        }
        catch (ResourceBusyFaultType e) {
            throw FaultToException.getResourceBusyException(e);
        }
        catch (InternalFaultType e) {
            throw FaultToException.getServerException(e);
        }
        catch (AuthorisationFaultType e) {
            throw FaultToException.getAuthorisationException(e);
        }
        catch (AxisFault e) {
            SOAPCall.checkUnsupportedOperation(this.mServiceURL.toString(), operationName, e);
        }
        catch (RemoteException e) {
            throw new ServiceCommsException(this.mServiceURL.toString(), e);
        }
    }

    public void putClosingBlock() throws ServerException, AuthorisationException, RequestException, ResourceUnknownException, ResourceBusyException, ServiceCommsException {
        this.putBlock(ServiceConstants.NO_MORE_DATA);
    }

    public void setConnectionProperty(ConnectionProperty property) {
        if (property == null) {
            throw new IllegalArgumentException("The property argument must not be null.");
        }
        property.configureCallFactory(this.mCallFactory);
    }

    private String getServiceURL() {
        String handle = "/DAI" + this.mResourceID.getName();
        return this.mServiceURL.toString() + handle;
    }
}

