/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.toolkit.wsi;

import java.net.MalformedURLException;
import java.rmi.RemoteException;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import org.apache.axis.AxisFault;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.SOAPBodyElement;
import uk.org.ogsadai.client.toolkit.ResourceID;
import uk.org.ogsadai.client.toolkit.exception.AuthorisationException;
import uk.org.ogsadai.client.toolkit.exception.FaultToException;
import uk.org.ogsadai.client.toolkit.exception.RequestException;
import uk.org.ogsadai.client.toolkit.exception.ResourceBusyException;
import uk.org.ogsadai.client.toolkit.exception.ResourceUnknownException;
import uk.org.ogsadai.client.toolkit.exception.ServerException;
import uk.org.ogsadai.client.toolkit.exception.ServiceCommsException;
import uk.org.ogsadai.client.toolkit.service.ConfigurableDataService;
import uk.org.ogsadai.client.toolkit.service.ServiceConstants;
import uk.org.ogsadai.client.toolkit.service.faults.AuthorisationFaultType;
import uk.org.ogsadai.client.toolkit.service.faults.InternalFaultType;
import uk.org.ogsadai.client.toolkit.service.faults.RequestFaultType;
import uk.org.ogsadai.client.toolkit.service.faults.ResourceBusyFaultType;
import uk.org.ogsadai.client.toolkit.service.faults.ResourceUnknownFaultType;
import uk.org.ogsadai.client.toolkit.soap.CTkSOAPException;
import uk.org.ogsadai.client.toolkit.soap.SOAPCall;
import uk.org.ogsadai.client.toolkit.wsi.WSIDataService;

public class ConfigurableWSIDataService
extends WSIDataService
implements ConfigurableDataService {
    private static final String COPYRIGHT_NOTICE = "(c) University of Edinburgh 2002 - 2006.";

    public ConfigurableWSIDataService(String url) throws MalformedURLException {
        super(url);
    }

    public ConfigurableWSIDataService(String url, ResourceID id) throws MalformedURLException {
        super(url, id);
    }

    public void deploy(String name) throws AuthorisationException, RequestException, ServerException, ServiceCommsException {
        QName operationName = ServiceConstants.DEPLOY_OP;
        SOAPBodyElement body = new SOAPBodyElement(operationName);
        try {
            MessageElement msg = new MessageElement("http://ogsadai.org.uk/namespaces/2005/10/service/config/types", "resourceID");
            msg.addTextNode(name);
            body.addChild(msg);
        }
        catch (SOAPException e) {
            throw new CTkSOAPException(e);
        }
        try {
            SOAPCall call = this.getCallFactory().createSOAPCall();
            call.invoke(this.getURL().toString(), operationName, body);
        }
        catch (RequestFaultType e) {
            throw FaultToException.getRequestException(e);
        }
        catch (InternalFaultType e) {
            throw FaultToException.getServerException(e);
        }
        catch (AuthorisationFaultType e) {
            throw FaultToException.getAuthorisationException(e);
        }
        catch (AxisFault e) {
            SOAPCall.checkUnsupportedOperation(this.getURL().toString(), operationName, e);
        }
        catch (RemoteException e) {
            throw new ServiceCommsException(this.getURL().toString(), e);
        }
    }

    public void undeploy(String name) throws AuthorisationException, ServerException, ServiceCommsException, ResourceBusyException, ResourceUnknownException {
        QName operationName = ServiceConstants.UNDEPLOY_OP;
        SOAPBodyElement body = new SOAPBodyElement(operationName);
        try {
            MessageElement msg = new MessageElement("http://ogsadai.org.uk/namespaces/2005/10/service/config/types", "resourceID");
            msg.addTextNode(name);
            body.addChild(msg);
        }
        catch (SOAPException e) {
            throw new CTkSOAPException(e);
        }
        try {
            SOAPCall call = this.getCallFactory().createSOAPCall();
            call.invoke(this.getURL().toString(), operationName, body);
        }
        catch (ResourceBusyFaultType e) {
            throw FaultToException.getResourceBusyException(e);
        }
        catch (ResourceUnknownFaultType e) {
            throw FaultToException.getResourceUnknownException(e);
        }
        catch (InternalFaultType e) {
            throw FaultToException.getServerException(e);
        }
        catch (AuthorisationFaultType e) {
            throw FaultToException.getAuthorisationException(e);
        }
        catch (AxisFault e) {
            SOAPCall.checkUnsupportedOperation(this.getURL().toString(), operationName, e);
        }
        catch (RemoteException e) {
            throw new ServiceCommsException(this.getURL().toString(), e);
        }
    }
}

