/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.toolkit.soap;

import [Lorg.w3c.dom.Element;;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.rmi.RemoteException;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import javax.activation.DataHandler;
import javax.xml.namespace.QName;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.attachments.AttachmentPart;
import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.axis.constants.Style;
import org.apache.axis.constants.Use;
import org.apache.axis.message.SOAPBodyElement;
import org.apache.axis.soap.SOAPConstants;
import org.apache.axis.utils.IOUtils;
import org.w3c.dom.Element;
import uk.org.ogsadai.client.toolkit.exception.SOAPAttachmentException;
import uk.org.ogsadai.client.toolkit.exception.ServiceCommsException;
import uk.org.ogsadai.client.toolkit.exception.UnsupportedOperationException;
import uk.org.ogsadai.client.toolkit.service.faults.DAIFaultType;
import uk.org.ogsadai.client.toolkit.soap.AttachmentManager;
import uk.org.ogsadai.client.toolkit.soap.CreateDAIFaultException;
import uk.org.ogsadai.client.toolkit.soap.MapAxisFaultException;
import uk.org.ogsadai.common.msgs.DAILogger;

public class SOAPCall {
    private static final String COPYRIGHT_NOTICE = "(c) University of Edinburgh 2002 - 2006.";
    private static final DAILogger LOG = DAILogger.getLogger(SOAPCall.class);
    private static final String FAULT_NS = "http://xml.apache.org/axis/";
    private static final String FAULT_LOCAL = "exceptionName";
    private final Service mService = new Service();
    private final Call mCall = new Call(this.mService);
    private final AttachmentManager mAttachmentManager = new AttachmentManager();
    private static final Properties mMappings = new Properties();

    public Call getCall() {
        return this.mCall;
    }

    public Vector invoke(String destination, QName operation, SOAPBodyElement body) throws DAIFaultType, RemoteException, ServiceCommsException {
        this.mCall.clearOperation();
        this.mCall.setOperationStyle(Style.DOCUMENT);
        this.mCall.setOperationName(operation);
        this.mCall.setTargetEndpointAddress(destination);
        this.mCall.setEncodingStyle(null);
        this.mCall.setProperty("sendXsiTypes", (Object)Boolean.FALSE);
        this.mCall.setProperty("sendMultiRefs", (Object)Boolean.FALSE);
        this.mCall.setSOAPVersion((SOAPConstants)SOAPConstants.SOAP11_CONSTANTS);
        this.mCall.setOperationUse(Use.LITERAL);
        try {
            Vector resultVector = (Vector)this.mCall.invoke((Object[])new SOAPBodyElement[]{body});
            Message response = this.mCall.getMessageContext().getResponseMessage();
            int attachmentsCount = response.countAttachments();
            if (attachmentsCount > 0) {
                this.processAttachments(response);
            }
            return resultVector;
        }
        catch (AxisFault e) {
            AxisFault mappedFault = this.getMappedFault(e.getFaultDetails());
            if (mappedFault != null) {
                throw mappedFault;
            }
            throw e;
        }
        catch (SOAPAttachmentException e) {
            throw new ServiceCommsException(destination, e);
        }
    }

    private void processAttachments(Message message) throws SOAPAttachmentException {
        Iterator iterator = message.getAttachments();
        while (iterator.hasNext()) {
            AttachmentPart ap = (AttachmentPart)iterator.next();
            String contentType = ap.getContentType();
            byte[] buffer = null;
            try {
                DataHandler dh = ap.getDataHandler();
                InputStream is = dh.getInputStream();
                buffer = new byte[is.available()];
                IOUtils.readFully((InputStream)is, (byte[])buffer);
                if (contentType.startsWith("text/plain")) {
                    this.mAttachmentManager.addRcvPlainText(buffer, ap.getContentId());
                    continue;
                }
                this.mAttachmentManager.addRcvOctetStreamText(buffer, ap.getContentId());
            }
            catch (Exception e) {
                throw new SOAPAttachmentException(e);
            }
        }
    }

    public AttachmentManager getAttachmentManager() {
        return this.mAttachmentManager;
    }

    private String getExceptionName(Element[] details) {
        String faultName = null;
        int numDetails = details.length;
        for (int i = 0; i < numDetails; ++i) {
            if (!FAULT_NS.equals(details[i].getNamespaceURI()) || !FAULT_LOCAL.equals(details[i].getLocalName())) continue;
            faultName = details[i].getFirstChild().getNodeValue();
            break;
        }
        return faultName;
    }

    private AxisFault getMappedFault(Element[] details) {
        if (details == null) {
            return null;
        }
        String serverFault = this.getExceptionName(details);
        if (serverFault == null) {
            return null;
        }
        String className = mMappings.getProperty(serverFault);
        if (className != null) {
            Object fault = null;
            try {
                Class<?> clazz = Class.forName(className);
                Constructor<?> constructor = clazz.getConstructor(Element;.class);
                fault = constructor.newInstance(new Object[]{details});
            }
            catch (Exception e) {
                CreateDAIFaultException ex = new CreateDAIFaultException(className, (Throwable)e);
                LOG.warn(ex);
            }
            return fault;
        }
        MapAxisFaultException ex = new MapAxisFaultException(serverFault);
        LOG.warn(ex);
        return null;
    }

    public static void checkUnsupportedOperation(String url, QName operationName, AxisFault e) throws UnsupportedOperationException, ServiceCommsException {
        if (e.getFaultString().equals("No such operation '" + operationName.getLocalPart() + "'")) {
            throw new UnsupportedOperationException(url, operationName);
        }
        throw new ServiceCommsException(url, (Exception)((Object)e));
    }

    static {
        mMappings.put("uk.org.ogsadai.service.faults.AuthorisationFaultType", "uk.org.ogsadai.client.toolkit.service.faults.AuthorisationFaultType");
        mMappings.put("uk.org.ogsadai.service.faults.RequestFaultType", "uk.org.ogsadai.client.toolkit.service.faults.RequestFaultType");
        mMappings.put("uk.org.ogsadai.service.faults.ResourceUnknownFaultType", "uk.org.ogsadai.client.toolkit.service.faults.ResourceUnknownFaultType");
        mMappings.put("uk.org.ogsadai.service.faults.ResourceBusyFaultType", "uk.org.ogsadai.client.toolkit.service.faults.ResourceBusyFaultType");
        mMappings.put("uk.org.ogsadai.service.faults.InternalFaultType", "uk.org.ogsadai.client.toolkit.service.faults.InternalFaultType");
        mMappings.put("org.oasis.wsrf.properties.ResourceUnknownFaultType", "uk.org.ogsadai.client.toolkit.service.faults.wsrp.ResourceUnknownFaultType");
        mMappings.put("org.oasis.wsrf.properties.InvalidResourcePropertyQNameFaultType", "uk.org.ogsadai.client.toolkit.service.faults.wsrp.InvalidResourcePropertyQNameFaultType");
        mMappings.put("uk.org.ogsadai.service.wsrp.ResourceUnknownFaultType", "uk.org.ogsadai.client.toolkit.service.faults.wsrp.ResourceUnknownFaultType");
        mMappings.put("uk.org.ogsadai.service.wsrp.InvalidResourcePropertyQNameFaultType", "uk.org.ogsadai.client.toolkit.service.faults.wsrp.InvalidResourcePropertyQNameFaultType");
    }
}

