/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.toolkit.soap;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import org.apache.axis.Message;
import org.apache.axis.attachments.AttachmentPart;
import org.apache.axis.attachments.ManagedMemoryDataSource;
import org.apache.axis.utils.IOUtils;
import uk.org.ogsadai.client.toolkit.exception.SOAPAttachmentException;
import uk.org.ogsadai.common.msgs.DAILogger;

public class AttachmentManager {
    private static final String COPYRIGHT_NOTICE = "(c) University of Edinburgh 2002 - 2006.";
    private static final DAILogger LOG = DAILogger.getLogger(AttachmentManager.class);
    private Vector mAttachmentParts = new Vector();

    public void addAttachments(Message message) {
        for (int i = 0; i < this.mAttachmentParts.size(); ++i) {
            message.addAttachmentPart((javax.xml.soap.AttachmentPart)((AttachmentPart)this.mAttachmentParts.get(i)));
        }
    }

    public String addNewPlainText(String data) throws IOException {
        AttachmentPart ap = new AttachmentPart(new DataHandler((DataSource)new MemoryOnlyDataSource(data.getBytes(), "text/plain")));
        this.mAttachmentParts.add(ap);
        return ap.getContentId();
    }

    public void addRcvPlainText(byte[] data, String contentID) throws IOException {
        AttachmentPart ap = new AttachmentPart(new DataHandler((DataSource)new MemoryOnlyDataSource(data, "text/plain")));
        ap.setContentId(contentID);
        this.mAttachmentParts.add(ap);
    }

    public String addNewOctetStream(byte[] data) throws IOException {
        AttachmentPart ap = new AttachmentPart(new DataHandler((DataSource)new MemoryOnlyDataSource(data, "application/octet-stream")));
        this.mAttachmentParts.add(ap);
        return ap.getContentId();
    }

    public void addRcvOctetStreamText(byte[] data, String contentID) throws IOException {
        AttachmentPart ap = new AttachmentPart(new DataHandler((DataSource)new MemoryOnlyDataSource(data, "application/octet-stream")));
        ap.setContentId(contentID);
        this.mAttachmentParts.add(ap);
    }

    public String addFile(File file) {
        AttachmentPart ap = new AttachmentPart(new DataHandler((DataSource)new FileDataSource(file)));
        this.mAttachmentParts.add(ap);
        return ap.getContentId();
    }

    public AttachmentPart getAttachmentPart(String contentID) {
        boolean found = false;
        AttachmentPart ap = null;
        for (int i = 0; i < this.mAttachmentParts.size(); ++i) {
            ap = (AttachmentPart)this.mAttachmentParts.get(i);
            if (!contentID.equals(ap.getContentId())) continue;
            found = true;
            break;
        }
        if (found) {
            return ap;
        }
        return null;
    }

    public InputStream getAttachmentAsInputStream(String contentID) throws SOAPAttachmentException {
        DataHandler dh = null;
        InputStream is = null;
        AttachmentPart ap = this.getAttachmentPart(contentID);
        try {
            dh = ap.getDataHandler();
            is = dh.getInputStream();
        }
        catch (Exception e) {
            new SOAPAttachmentException(e);
        }
        return is;
    }

    public byte[] getAttachmentAsByteArray(String contentID) throws SOAPAttachmentException {
        InputStream is = null;
        byte[] buffer = null;
        try {
            is = this.getAttachmentAsInputStream(contentID);
            buffer = new byte[is.available()];
            IOUtils.readFully((InputStream)is, (byte[])buffer);
        }
        catch (Exception e) {
            new SOAPAttachmentException(e);
        }
        return buffer;
    }

    public String getAttachmentAsString(String contentID) throws SOAPAttachmentException {
        return new String(this.getAttachmentAsByteArray(contentID));
    }

    static class MemoryOnlyDataSource
    extends ManagedMemoryDataSource {
        private static final String COPYRIGHT_NOTICE = "(c) University of Edinburgh 2002 - 2006.";

        MemoryOnlyDataSource(byte[] in, String contentType) throws IOException {
            super((InputStream)new ByteArrayInputStream(in), 0x7FFFFFFD, contentType, true);
        }
    }
}

