/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.toolkit.sessions;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import uk.org.ogsadai.client.toolkit.exception.AuthorisationException;
import uk.org.ogsadai.client.toolkit.exception.DataFormatException;
import uk.org.ogsadai.client.toolkit.exception.ResourceUnknownException;
import uk.org.ogsadai.client.toolkit.exception.ServerException;
import uk.org.ogsadai.client.toolkit.exception.ServiceCommsException;
import uk.org.ogsadai.client.toolkit.properties.RequestStatus;
import uk.org.ogsadai.client.toolkit.properties.UnknownPropertyException;
import uk.org.ogsadai.client.toolkit.service.DataService;
import uk.org.ogsadai.client.toolkit.sessions.Session;
import uk.org.ogsadai.client.toolkit.sessions.SessionID;
import uk.org.ogsadai.common.xml.XMLUtilities;

public class SessionImpl
implements Session {
    private static final String COPYRIGHT_NOTICE = "(c) University of Edinburgh 2005.";
    private SessionID mSessionID;
    private DataService mDataService;

    public SessionImpl(DataService dataService, Document response) throws DataFormatException {
        if (dataService == null) {
            throw new IllegalArgumentException("The dataService argument must not be null.");
        }
        if (response == null) {
            throw new IllegalArgumentException("The response argument must not be null.");
        }
        Element root = response.getDocumentElement();
        NodeList nodes = root.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "session");
        if (nodes.getLength() == 0) {
            throw new DataFormatException(XMLUtilities.xmlDOMToString(response));
        }
        Element session = (Element)nodes.item(0);
        this.mDataService = dataService;
        String id = session.getAttribute("id");
        if (id == null) {
            throw new DataFormatException(XMLUtilities.xmlDOMToString(response));
        }
        this.mSessionID = new SessionID(id);
    }

    public SessionID getSessionID() {
        return this.mSessionID;
    }

    public RequestStatus getStatus() throws AuthorisationException, ResourceUnknownException, UnknownPropertyException, DataFormatException, ServerException, ServiceCommsException {
        return this.mDataService.getStatus(this.mSessionID);
    }
}

