/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.toolkit.service.faults;

import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import uk.org.ogsadai.client.toolkit.service.faults.ComplexFaultType;
import uk.org.ogsadai.client.toolkit.service.faults.ReasonFaultType;

public abstract class ChainedFaultType
extends ComplexFaultType {
    private static final String COPYRIGHT_NOTICE = "(c) University of Edinburgh 2002 - 2005.";
    private ReasonFaultType[] mCauses;
    public static String CAUSE_LOCALNAME = "reason";

    public ChainedFaultType(String id, String msg) {
        super(id, msg);
    }

    public ChainedFaultType(String id, String msg, String[] params) {
        super(id, msg, params);
    }

    public ChainedFaultType(String id, String msg, String[] params, ReasonFaultType[] causes) {
        super(id, msg, params);
        this.mCauses = causes;
    }

    public ChainedFaultType(Element[] details) {
        super(details);
    }

    protected void parseFaultDetails(Element element) {
        super.parseFaultDetails(element);
        NodeList causeNodes = element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/service/faults", CAUSE_LOCALNAME);
        if (causeNodes != null) {
            int numCauses = causeNodes.getLength();
            this.mCauses = new ReasonFaultType[numCauses];
            for (int j = 0; j < numCauses; ++j) {
                Node cause = causeNodes.item(j);
                if (cause == null || cause.getFirstChild() == null) continue;
                this.mCauses[j] = new ReasonFaultType(new Element[]{(Element)cause});
            }
        }
    }

    public ReasonFaultType[] getCauses() {
        return this.mCauses;
    }

    public void setCauses(ReasonFaultType[] causes) {
        this.mCauses = causes;
    }

    public ReasonFaultType getCause(int i) {
        return this.mCauses[i];
    }

    public void setCause(int i, ReasonFaultType cause) {
        this.mCauses[i] = cause;
    }
}

