/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.toolkit.properties;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import uk.org.ogsadai.client.toolkit.exception.DataFormatException;
import uk.org.ogsadai.client.toolkit.properties.Property;
import uk.org.ogsadai.client.toolkit.properties.UnknownRequestStatusException;
import uk.org.ogsadai.common.xml.XMLUtilities;

public final class RequestStatus {
    private static final String COPYRIGHT_NOTICE = "(c) University of Edinburgh 2002 - 2006.";
    public static final RequestStatus UNSTARTED = new RequestStatus("UNSTARTED");
    public static final RequestStatus INITIALISING = new RequestStatus("INITIALISING");
    public static final RequestStatus PROCESSING = new RequestStatus("PROCESSING");
    public static final RequestStatus COMPLETED = new RequestStatus("COMPLETED");
    public static final RequestStatus ERROR = new RequestStatus("ERROR");
    public static final RequestStatus TERMINATED = new RequestStatus("TERMINATED");
    public static final RequestStatus TIMEDOUT = new RequestStatus("TIMEDOUT");
    private final String mText;

    private RequestStatus(String text) {
        this.mText = text;
    }

    public String toString() {
        return this.mText;
    }

    public boolean isStopped() {
        return this == ERROR || this == TERMINATED || this == TIMEDOUT;
    }

    public boolean isFinished() {
        return this == COMPLETED || this == ERROR || this == TERMINATED || this == TIMEDOUT;
    }

    public boolean isUnfinished() {
        return this == UNSTARTED || this == INITIALISING || this == PROCESSING;
    }

    public boolean isUnstarted() {
        return this == UNSTARTED;
    }

    public static RequestStatus createFromProperty(Property property) throws DataFormatException {
        RequestStatus status = null;
        String state = null;
        Object value = property.getValue();
        if (!(value instanceof Element)) {
            throw new DataFormatException("org.w3c.dom.Element", "" + value);
        }
        Element root = (Element)value;
        NodeList nodes = root.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/properties", "requestStatus");
        if (nodes.getLength() == 0) {
            throw new DataFormatException(XMLUtilities.xmlDOMToString(root));
        }
        Element requestStatus = (Element)nodes.item(0);
        state = requestStatus.getAttribute("state");
        if (state.equals(RequestStatus.UNSTARTED.mText)) {
            status = UNSTARTED;
        } else if (state.equals(RequestStatus.INITIALISING.mText)) {
            status = INITIALISING;
        } else if (state.equals(RequestStatus.PROCESSING.mText)) {
            status = PROCESSING;
        } else if (state.equals(RequestStatus.COMPLETED.mText)) {
            status = COMPLETED;
        } else if (state.equals(RequestStatus.ERROR.mText)) {
            status = ERROR;
        } else if (state.equals(RequestStatus.TERMINATED.mText)) {
            status = TERMINATED;
        } else if (state.equals(RequestStatus.TIMEDOUT.mText)) {
            status = TIMEDOUT;
        }
        if (status == null) {
            throw new DataFormatException(new UnknownRequestStatusException(state));
        }
        return status;
    }

    public static RequestStatus createFromResponse(Document response) throws DataFormatException {
        RequestStatus status = null;
        String state = null;
        Element root = response.getDocumentElement();
        NodeList nodes = root.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "request");
        if (nodes.getLength() == 0) {
            throw new DataFormatException(XMLUtilities.xmlDOMToString(root));
        }
        Element requestStatus = (Element)nodes.item(0);
        state = requestStatus.getAttribute("status");
        if (state.equals(RequestStatus.UNSTARTED.mText)) {
            status = UNSTARTED;
        } else if (state.equals(RequestStatus.INITIALISING.mText)) {
            status = INITIALISING;
        } else if (state.equals(RequestStatus.PROCESSING.mText)) {
            status = PROCESSING;
        } else if (state.equals(RequestStatus.COMPLETED.mText)) {
            status = COMPLETED;
        } else if (state.equals(RequestStatus.ERROR.mText)) {
            status = ERROR;
        } else if (state.equals(RequestStatus.TERMINATED.mText)) {
            status = TERMINATED;
        } else if (state.equals(RequestStatus.TIMEDOUT.mText)) {
            status = TIMEDOUT;
        }
        if (status == null) {
            throw new DataFormatException(new UnknownRequestStatusException(state));
        }
        return status;
    }
}

