/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.toolkit.properties;

import javax.xml.namespace.QName;
import org.w3c.dom.Element;
import uk.org.ogsadai.client.toolkit.exception.DataFormatException;
import uk.org.ogsadai.client.toolkit.properties.Property;
import uk.org.ogsadai.common.xml.XMLUtilities;

public class PropertyUtilities {
    private static final String COPYRIGHT_NOTICE = "(c) University of Edinburgh 2002 - 2006.";

    public static String getAsString(Property property) throws DataFormatException {
        Object value = property.getValue();
        if (!(value instanceof Element)) {
            throw new DataFormatException("org.w3c.dom.Element", "" + value);
        }
        String result = null;
        Element element = (Element)value;
        if (element.getFirstChild().getNodeType() != 3) {
            throw new DataFormatException("org.w3c.dom.Text", XMLUtilities.xmlDOMToString(element.getFirstChild()));
        }
        result = element.getFirstChild().getNodeValue();
        return result;
    }

    public static int getAsInt(Property property) throws DataFormatException {
        int value;
        try {
            value = Integer.parseInt(PropertyUtilities.getAsString(property));
        }
        catch (NumberFormatException e) {
            throw new DataFormatException("java.lang.Integer", XMLUtilities.xmlDOMToString((Element)property.getValue()), e);
        }
        return value;
    }

    public static float getAsFloat(Property property) throws DataFormatException {
        float value;
        try {
            value = Float.parseFloat(PropertyUtilities.getAsString(property));
        }
        catch (NumberFormatException e) {
            throw new DataFormatException("java.lang.Float", XMLUtilities.xmlDOMToString((Element)property.getValue()), e);
        }
        return value;
    }

    public static boolean getAsBoolean(Property property) throws DataFormatException {
        return Boolean.getBoolean(PropertyUtilities.getAsString(property));
    }

    public static QName getAsQName(Property property) throws DataFormatException {
        String ln;
        String ns;
        Object value = property.getValue();
        if (!(value instanceof Element)) {
            throw new DataFormatException("org.w3c.dom.Element", "" + value);
        }
        QName result = null;
        Element element = (Element)property.getValue();
        if (element.getFirstChild().getNodeType() == 3) {
            String nodeValue = element.getFirstChild().getNodeValue();
            int index = nodeValue.indexOf(":");
            if (index < 0) {
                ns = element.getNamespaceURI();
                ln = nodeValue;
            } else {
                String prefix = nodeValue.substring(0, index);
                ns = element.getAttributeNS("http://www.w3.org/2000/xmlns/", prefix);
                ln = nodeValue.substring(index + 1);
            }
        } else {
            throw new DataFormatException("org.w3c.dom.Text", XMLUtilities.xmlDOMToString(element.getFirstChild()));
        }
        result = new QName(ns, ln);
        return result;
    }
}

