/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.toolkit.properties;

import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import uk.org.ogsadai.client.toolkit.properties.Property;
import uk.org.ogsadai.client.toolkit.service.ServiceConstants;

public class DataServiceInfo {
    private static final String COPYRIGHT_NOTICE = "(c) University of Edinburgh 2002 - 2006.";
    private String mDescription;
    private String mLastResponse;
    public static final String DATA_SERVICE = "aDataService";
    public static final String DESCRIPTION = "serviceDescription";
    public static final String RESPONSE = "lastResponse";

    public static DataServiceInfo[] getInfoForServices(Property property) {
        DataServiceInfo[] result = null;
        try {
            Element element = (Element)property.getValue();
            String namespace = ServiceConstants.STATUS_OF_DATA_SERVICES.getNamespaceURI();
            NodeList services = element.getElementsByTagNameNS(namespace, DATA_SERVICE);
            result = new DataServiceInfo[services.getLength()];
            for (int i = 0; i < result.length; ++i) {
                Element service = (Element)services.item(i);
                String desc = service.getElementsByTagNameNS(namespace, DESCRIPTION).item(0).getFirstChild().getNodeValue();
                String response = service.getElementsByTagNameNS(namespace, RESPONSE).item(0).getFirstChild().getNodeValue();
                result[i] = new DataServiceInfo();
                result[i].setDescription(desc);
                result[i].setLastResponse(response);
            }
        }
        catch (Exception e) {
            result = null;
        }
        return result;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public String getLastResponse() {
        return this.mLastResponse;
    }

    private void setDescription(String description) {
        this.mDescription = description;
    }

    private void setLastResponse(String lastResponse) {
        this.mLastResponse = lastResponse;
    }
}

