/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.toolkit.properties;

import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import uk.org.ogsadai.client.toolkit.exception.DataFormatException;
import uk.org.ogsadai.client.toolkit.properties.Property;
import uk.org.ogsadai.client.toolkit.service.ServiceConstants;
import uk.org.ogsadai.common.xml.XMLUtilities;

public class DataResourceInfo {
    private static final String COPYRIGHT_NOTICE = "(c) University of Edinburgh 2002 - 2006.";
    private String mName;
    private String mVendor;
    private String mVersion;

    private DataResourceInfo(String name, String vendor, String version) {
        this.mName = name;
        this.mVendor = vendor;
        this.mVersion = version;
    }

    public String getName() {
        return this.mName;
    }

    public String getVendor() {
        return this.mVendor;
    }

    public String getVersion() {
        return this.mVersion;
    }

    public static DataResourceInfo createFromProperty(Property property) throws DataFormatException {
        Object value = property.getValue();
        if (!(value instanceof Element)) {
            throw new DataFormatException("org.w3c.dom.Element", "" + value);
        }
        String productName = null;
        String version = null;
        String vendor = null;
        Element element = (Element)property.getValue();
        String name = element.getLocalName();
        if (name == null || !name.equals(ServiceConstants.PRODUCT_INFO.getLocalPart())) {
            throw new DataFormatException(XMLUtilities.xmlDOMToString(element));
        }
        NodeList list = element.getElementsByTagNameNS(ServiceConstants.PRODUCT_INFO.getNamespaceURI(), "productName");
        if (list == null || list.getLength() == 0) {
            throw new DataFormatException(XMLUtilities.xmlDOMToString(element));
        }
        Node nameNode = list.item(0);
        if (nameNode != null && (nameNode = nameNode.getFirstChild()) != null) {
            productName = nameNode.getNodeValue();
        }
        if ((list = element.getElementsByTagNameNS(ServiceConstants.PRODUCT_INFO.getNamespaceURI(), "productVersion")) == null || list.getLength() == 0) {
            throw new DataFormatException(XMLUtilities.xmlDOMToString(element));
        }
        Node versionNode = list.item(0);
        if (versionNode != null && (versionNode = versionNode.getFirstChild()) != null) {
            version = versionNode.getNodeValue();
        }
        if ((list = element.getElementsByTagNameNS(ServiceConstants.PRODUCT_INFO.getNamespaceURI(), "vendorName")) == null || list.getLength() == 0) {
            throw new DataFormatException(XMLUtilities.xmlDOMToString(element));
        }
        Node vendorNode = list.item(0);
        if (vendorNode != null && (vendorNode = vendorNode.getFirstChild()) != null) {
            vendor = vendorNode.getNodeValue();
        }
        DataResourceInfo info = new DataResourceInfo(productName, vendor, version);
        return info;
    }
}

