/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.toolkit.properties;

import uk.org.ogsadai.client.toolkit.ServiceType;
import uk.org.ogsadai.client.toolkit.exception.DataFormatException;
import uk.org.ogsadai.client.toolkit.properties.Property;
import uk.org.ogsadai.client.toolkit.properties.PropertyUtilities;

public class DAIVersion {
    private static final String COPYRIGHT_NOTICE = "(c) University of Edinburgh 2002 - 2006.";
    private ServiceType mServiceType;
    private String mTypeAndVersion;
    private int mMinorVersion;
    private int mMajorVersion;

    public DAIVersion(String typeAndVersion) {
        String remains;
        int wsrfIndex;
        this.mTypeAndVersion = typeAndVersion;
        this.mMinorVersion = 0;
        this.mMajorVersion = 0;
        if (this.mTypeAndVersion == null) {
            this.mTypeAndVersion = "";
        }
        if ((wsrfIndex = (remains = this.mTypeAndVersion).indexOf("WSRF")) >= 0) {
            this.mServiceType = ServiceType.WSRF;
            remains = this.mTypeAndVersion.substring(wsrfIndex + 5);
        } else {
            int wsiIndex = remains.indexOf("WSI");
            if (wsiIndex >= 0) {
                this.mServiceType = ServiceType.WSI;
                remains = this.mTypeAndVersion.substring(wsiIndex + 4);
            } else {
                this.mServiceType = ServiceType.UNKNOWN;
            }
        }
        int point = remains.indexOf(".");
        String major = remains.substring(0, point);
        try {
            this.mMajorVersion = Integer.valueOf(major);
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        String minor = remains.substring(point + 1);
        try {
            this.mMinorVersion = Integer.valueOf(minor);
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
    }

    public int getMinorVersion() {
        return this.mMinorVersion;
    }

    public int getMajorVersion() {
        return this.mMajorVersion;
    }

    public String toString() {
        return this.mTypeAndVersion;
    }

    public ServiceType getServiceType() {
        return this.mServiceType;
    }

    public static DAIVersion createFromProperty(Property property) throws DataFormatException {
        String version = PropertyUtilities.getAsString(property);
        return new DAIVersion(version);
    }
}

