/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.toolkit.properties;

import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import uk.org.ogsadai.client.toolkit.exception.DataFormatException;
import uk.org.ogsadai.client.toolkit.properties.Property;
import uk.org.ogsadai.common.xml.XMLUtilities;

public class ActivityMetaData {
    private static final String COPYRIGHT_NOTICE = "(c) University of Edinburgh 2002 - 2006.";
    private String mName;
    private String mDescription;

    private ActivityMetaData(Element element) {
        this.mName = element.getAttribute("name");
        NodeList nodes = element.getElementsByTagName("description");
        this.mDescription = nodes.getLength() > 0 ? XMLUtilities.getTextContent(nodes.item(0)) : "";
    }

    public String getName() {
        return this.mName;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public String toString() {
        return "[ActivityMetaData:" + this.getName() + "]";
    }

    public static ActivityMetaData[] createFromProperty(Property property) throws DataFormatException {
        Object value = property.getValue();
        if (!(value instanceof Element)) {
            throw new DataFormatException("org.w3c.dom.Element", "" + value);
        }
        Element activityTypes = (Element)property.getValue();
        NodeList supportedActivities = activityTypes.getElementsByTagName("activity");
        if (supportedActivities == null) {
            throw new DataFormatException(XMLUtilities.xmlDOMToString(activityTypes));
        }
        int numActivities = supportedActivities.getLength();
        ActivityMetaData[] metadata = new ActivityMetaData[numActivities];
        for (int i = 0; i < numActivities; ++i) {
            metadata[i] = new ActivityMetaData((Element)supportedActivities.item(i));
        }
        return metadata;
    }
}

