/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.toolkit.exception;

import uk.org.ogsadai.client.toolkit.exception.AuthorisationException;
import uk.org.ogsadai.client.toolkit.exception.RequestException;
import uk.org.ogsadai.client.toolkit.exception.RequestExecutionException;
import uk.org.ogsadai.client.toolkit.exception.RequestMaximumReachedException;
import uk.org.ogsadai.client.toolkit.exception.ResourceBusyException;
import uk.org.ogsadai.client.toolkit.exception.ResourceIDAlreadyAssignedException;
import uk.org.ogsadai.client.toolkit.exception.ResourceUnknownException;
import uk.org.ogsadai.client.toolkit.exception.ServerException;
import uk.org.ogsadai.client.toolkit.exception.UnknownSessionException;
import uk.org.ogsadai.client.toolkit.exception.UnknownSessionStreamException;
import uk.org.ogsadai.client.toolkit.exception.UnsupportedActivityException;
import uk.org.ogsadai.client.toolkit.properties.UnknownPropertyException;
import uk.org.ogsadai.client.toolkit.service.faults.AuthorisationFaultType;
import uk.org.ogsadai.client.toolkit.service.faults.ComplexFaultType;
import uk.org.ogsadai.client.toolkit.service.faults.InternalFaultType;
import uk.org.ogsadai.client.toolkit.service.faults.ReasonFaultType;
import uk.org.ogsadai.client.toolkit.service.faults.RequestFaultType;
import uk.org.ogsadai.client.toolkit.service.faults.ResourceBusyFaultType;
import uk.org.ogsadai.client.toolkit.service.faults.wsrp.InvalidResourcePropertyQNameFaultType;
import uk.org.ogsadai.client.toolkit.service.faults.wsrp.ResourceUnknownFaultType;
import uk.org.ogsadai.exception.ErrorID;

public class FaultToException {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2006. (c) University of Edinburgh 2002 - 2006.";

    public static ServerException getServerException(InternalFaultType fault) {
        return new ServerException(fault.getUniqueID());
    }

    public static AuthorisationException getAuthorisationException(AuthorisationFaultType fault) {
        return new AuthorisationException(fault.getUniqueID());
    }

    public static ResourceBusyException getResourceBusyException(ResourceBusyFaultType fault) {
        return new ResourceBusyException(fault.getResourceID());
    }

    public static ResourceUnknownException getResourceUnknownException(uk.org.ogsadai.client.toolkit.service.faults.ResourceUnknownFaultType fault) {
        return new ResourceUnknownException(fault.getResourceID());
    }

    public static ResourceUnknownException getResourceUnknownException(ResourceUnknownFaultType fault) {
        return new ResourceUnknownException(fault.getResourceID());
    }

    public static UnknownPropertyException getUnknownPropertyException(InvalidResourcePropertyQNameFaultType fault) {
        return new UnknownPropertyException(fault.getProperty());
    }

    public static RequestException getRequestException(RequestFaultType fault) {
        RequestException topException = FaultToException.getSoloRequestException(fault);
        ReasonFaultType[] faults = fault.getCauses();
        int numFaults = 0;
        if (faults != null) {
            numFaults = faults.length;
        }
        RequestException parent = topException;
        for (int i = 0; i < numFaults; ++i) {
            ReasonFaultType subFault = faults[i];
            RequestException exception = FaultToException.getSoloRequestException(subFault);
            parent.initCause(exception);
            parent = exception;
        }
        for (RequestException exception = topException; exception != null; exception = (RequestException)exception.getCause()) {
            if (exception instanceof UnsupportedActivityException) {
                topException = exception;
                break;
            }
            if (exception instanceof UnknownSessionException) {
                topException = exception;
                break;
            }
            if (exception instanceof RequestMaximumReachedException) {
                topException = exception;
                break;
            }
            if (exception instanceof UnknownSessionStreamException) {
                topException = exception;
                break;
            }
            if (exception instanceof ResourceIDAlreadyAssignedException) {
                topException = exception;
                break;
            }
            if (!(exception instanceof RequestExecutionException)) continue;
            topException = exception;
            break;
        }
        return topException;
    }

    private static RequestException getSoloRequestException(ComplexFaultType fault) {
        String id = fault.getID();
        String msg = fault.getMsg();
        Object[] params = fault.getParameters();
        RequestException exception = null;
        exception = id.equals(ErrorID.UNSUPPORTED_ACTIVITY_ERROR.toString()) ? new UnsupportedActivityException(params[0]) : (id.equals(ErrorID.NO_SUCH_SESSION.toString()) ? new UnknownSessionException(params[0]) : (id.equals(ErrorID.REQUEST_MAX_REACHED_ERROR.toString()) ? new RequestMaximumReachedException(new Integer(params[0]), new Integer(params[1])) : (id.equals(ErrorID.UNABLE_TO_ACCESS_SESSION_STREAM.toString()) ? new UnknownSessionStreamException(params[0], params[1]) : (id.equals(ErrorID.RESOURCE_ID_ALREADY_ASSIGNED_ERROR.toString()) ? new ResourceIDAlreadyAssignedException(params[0]) : (id.equals(ErrorID.REQUEST_SPECIFICATION_PARTIAL_RESPONSE_ERROR.toString()) ? new RequestExecutionException(params[0]) : new RequestException(new ErrorID(id), params))))));
        return exception;
    }
}

