/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.toolkit.activity.xmldb;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import uk.org.ogsadai.client.toolkit.activity.Activity;
import uk.org.ogsadai.client.toolkit.activity.ActivityOutput;
import uk.org.ogsadai.client.toolkit.activity.NoActivityOutputException;
import uk.org.ogsadai.client.toolkit.exception.DataFormatException;
import uk.org.ogsadai.common.xml.XMLUtilities;

public class XUpdate
extends Activity {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2006. (c) University of Edinburgh 2002 - 2006.";
    private String mExpression = "";
    private String mResourceName = "";
    private String mCollectionName = "";

    public XUpdate() {
        this.addOutput("XUpdateResult");
    }

    public XUpdate(String expression) {
        this();
        this.setExpression(expression);
    }

    public void setExpression(String expression) {
        if (expression == null) {
            throw new IllegalArgumentException("expression must not be null");
        }
        this.mExpression = expression;
    }

    public void setResourceName(String resourceName) {
        this.mResourceName = resourceName;
    }

    public void setCollectionName(String collectionName) {
        this.mCollectionName = collectionName;
    }

    public ActivityOutput getOutput() {
        ActivityOutput createResourceOutput = this.getOutputs()[0];
        return createResourceOutput;
    }

    public int getModifiedNodes() throws NoActivityOutputException, DataFormatException {
        ActivityOutput createResourceOutput = this.getOutputs()[0];
        String outputData = createResourceOutput.getData();
        int numNodes = 0;
        try {
            Document doc = XMLUtilities.xmlStringToDOM(outputData, false);
            Element elt = (Element)doc.getElementsByTagName("modifiedNodes").item(0);
            numNodes = Integer.parseInt(elt.getFirstChild().getNodeValue());
        }
        catch (Exception e) {
            throw new DataFormatException(outputData, e);
        }
        return numNodes;
    }

    protected String generateXML() {
        StringBuffer sb = new StringBuffer();
        sb.append("<xUpdateStatement name=\"");
        sb.append(this.getName());
        sb.append("\">\n");
        if (this.mCollectionName != null && !this.mCollectionName.equals("")) {
            sb.append("<collection>");
            sb.append(this.replaceSpecialCharacters(this.mCollectionName));
            sb.append("</collection>\n");
        }
        if (this.mResourceName != null && !this.mResourceName.equals("")) {
            sb.append("<resourceId>");
            sb.append(this.replaceSpecialCharacters(this.mResourceName));
            sb.append("</resourceId>\n");
        }
        sb.append("<expression>");
        sb.append(this.mExpression);
        sb.append("</expression>\n");
        sb.append("<outputStream name=\"");
        sb.append(this.getOutputs()[0].getName());
        sb.append("\"/>\n");
        sb.append("</xUpdateStatement>\n");
        return sb.toString();
    }
}

