/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.toolkit.activity.xmldb;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.w3c.dom.Document;
import org.xmldb.api.base.ResourceSet;
import uk.org.ogsadai.client.toolkit.activity.Activity;
import uk.org.ogsadai.client.toolkit.activity.ActivityOutput;
import uk.org.ogsadai.client.toolkit.activity.NoActivityOutputException;
import uk.org.ogsadai.client.toolkit.activity.xmldb.ResourceSetDocumentConverter;
import uk.org.ogsadai.client.toolkit.exception.DataFormatException;
import uk.org.ogsadai.common.xml.XMLUtilities;

public class XQuery
extends Activity {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2006. (c) University of Edinburgh 2002 - 2006.";
    private String mExpression = "";
    private String mResourceName = "";
    private String mCollectionName = "";
    private Map mNamespaces = new Hashtable();

    public XQuery() {
        this.addOutput("XQueryResult");
    }

    public XQuery(String expression) {
        this();
        this.setExpression(expression);
    }

    public void setExpression(String expression) {
        if (expression == null) {
            throw new IllegalArgumentException("expression must not be null");
        }
        this.mExpression = expression;
    }

    public void setResourceName(String resourceName) {
        this.mResourceName = resourceName;
    }

    public void setCollectionName(String collectionName) {
        this.mCollectionName = collectionName;
    }

    public void setNamespaceBinding(String prefix, String url) {
        if (prefix == null) {
            throw new IllegalArgumentException("prefix must not be null");
        }
        if (url == null) {
            throw new IllegalArgumentException("url must not be null");
        }
        try {
            URL urlTest = new URL(url);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("url must be a legal URL : " + url);
        }
        this.mNamespaces.put(prefix, url);
    }

    public void setNamespaceBindings(Map bindings) {
        if (bindings == null) {
            throw new IllegalArgumentException("bindings must not be null");
        }
        Iterator iterator = bindings.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry binding = iterator.next();
            Object key = binding.getKey();
            Object value = binding.getKey();
            if (!(key instanceof String)) {
                throw new IllegalArgumentException("bindings contains a prefix that is not a string: " + key);
            }
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("bindings contains a URL that is not a string: " + key);
            }
            this.setNamespaceBinding((String)binding.getKey(), (String)binding.getValue());
        }
    }

    public ActivityOutput getOutput() {
        ActivityOutput createResourceOutput = this.getOutputs()[0];
        return createResourceOutput;
    }

    public ResourceSet getResourceSet() throws NoActivityOutputException, DataFormatException {
        ActivityOutput createResourceOutput = this.getOutputs()[0];
        String outputData = createResourceOutput.getData();
        ResourceSet resourceSet = null;
        try {
            Document doc = XMLUtilities.xmlStringToDOM(outputData, false);
            resourceSet = ResourceSetDocumentConverter.convert(doc);
        }
        catch (Exception e) {
            throw new DataFormatException(outputData, e);
        }
        return resourceSet;
    }

    protected String generateXML() {
        StringBuffer sb = new StringBuffer();
        sb.append("<xQueryStatement name=\"");
        sb.append(this.getName());
        sb.append("\">\n");
        if (this.mCollectionName != null && !this.mCollectionName.equals("")) {
            sb.append("<collection>");
            sb.append(this.replaceSpecialCharacters(this.mCollectionName));
            sb.append("</collection>\n");
        }
        if (this.mResourceName != null && !this.mResourceName.equals("")) {
            sb.append("<resourceId>");
            sb.append(this.replaceSpecialCharacters(this.mResourceName));
            sb.append("</resourceId>\n");
        }
        Iterator iterator = this.mNamespaces.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry binding = iterator.next();
            sb.append("<namespace prefix=\"");
            sb.append((String)binding.getKey());
            sb.append("\">");
            sb.append((String)binding.getValue());
            sb.append("</namespace>\n");
        }
        sb.append("<expression>");
        sb.append(this.replaceSpecialCharacters(this.mExpression));
        sb.append("</expression>\n");
        sb.append("<resourceSetStream name=\"");
        sb.append(this.getOutputs()[0].getName());
        sb.append("\"/>\n");
        sb.append("</xQueryStatement>\n");
        return sb.toString();
    }
}

