/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.toolkit.activity.xmldb;

import org.xmldb.api.base.Resource;
import org.xmldb.api.base.ResourceIterator;
import org.xmldb.api.base.ResourceSet;
import org.xmldb.api.base.XMLDBException;
import uk.org.ogsadai.common.BlockMaker;
import uk.org.ogsadai.common.BlockMakerException;

public class XMLResourceSetBlockMaker
implements BlockMaker {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2006. (c) University of Edinburgh 2002 - 2006";
    private static final String HEADER = "<resourceSet>\n";
    private static final String FOOTER = "</resourceSet>\n";
    private ResourceIterator mResourceIterator;
    private boolean mMoreBlocks = true;
    private boolean mFirstCall = true;

    public XMLResourceSetBlockMaker(ResourceSet resourceSet) throws BlockMakerException {
        if (resourceSet == null) {
            throw new IllegalArgumentException("resourceSet must not be null");
        }
        try {
            this.mResourceIterator = resourceSet.getIterator();
        }
        catch (XMLDBException e) {
            throw new BlockMakerException(e);
        }
    }

    public boolean hasNext() throws BlockMakerException {
        return this.mMoreBlocks;
    }

    public Object next() throws BlockMakerException {
        String block = null;
        if (this.mFirstCall) {
            block = HEADER;
            this.mFirstCall = false;
        } else {
            try {
                if (this.mResourceIterator.hasMoreResources()) {
                    Resource resource = this.mResourceIterator.nextResource();
                    block = this.resourceToXML(resource);
                } else {
                    block = FOOTER;
                    this.mMoreBlocks = false;
                }
            }
            catch (XMLDBException e) {
                throw new BlockMakerException(e);
            }
        }
        return block;
    }

    private String resourceToXML(Resource resource) throws XMLDBException {
        StringBuffer resourceSet = new StringBuffer();
        String resourceString = (String)resource.getContent();
        if (resourceString.substring(0, 5).equals("<?xml")) {
            resourceString = resourceString.substring(resourceString.indexOf(62) + 1);
        }
        resourceSet.append("  <").append("resource").append(">\n");
        resourceSet.append(resourceString);
        resourceSet.append("\n  </").append("resource").append(">\n");
        return resourceSet.toString();
    }
}

