/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.toolkit.activity.xmldb;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import uk.org.ogsadai.client.toolkit.activity.Activity;
import uk.org.ogsadai.client.toolkit.activity.ActivityOutput;
import uk.org.ogsadai.client.toolkit.activity.NoActivityOutputException;
import uk.org.ogsadai.client.toolkit.exception.DataFormatException;
import uk.org.ogsadai.common.xml.XMLUtilities;

public class XMLListResources
extends Activity {
    private static final String COPYRIGHT_NOTICE = "(c) University of Edinburgh 2002 - 2006.";
    private String mCollectionName = "";

    public XMLListResources() {
        this.addOutput("ListResourcesResult");
    }

    public void setCollectionName(String collectionName) {
        this.mCollectionName = collectionName;
    }

    public String[] getResourceNames() throws NoActivityOutputException, DataFormatException {
        String[] resources = null;
        ActivityOutput createResourceOutput = this.getOutputs()[0];
        String outputData = createResourceOutput.getData();
        try {
            Document doc = XMLUtilities.xmlStringToDOM(outputData, false);
            Element elt = (Element)doc.getElementsByTagName("resourceNames").item(0);
            String countString = elt.getAttribute("count");
            int numResources = Integer.parseInt(countString);
            NodeList kids = elt.getElementsByTagName("name");
            resources = new String[numResources];
            for (int i = 0; i < numResources; ++i) {
                resources[i] = kids.item(i).getFirstChild().getNodeValue();
            }
        }
        catch (Exception e) {
            throw new DataFormatException(outputData, e);
        }
        return resources;
    }

    public ActivityOutput getOutput() {
        ActivityOutput listResourcesOutput = this.getOutputs()[0];
        return listResourcesOutput;
    }

    protected String generateXML() {
        StringBuffer sb = new StringBuffer();
        sb.append("<xmlResourceManagement name=\"");
        sb.append(this.getName());
        sb.append("\">\n");
        if (this.mCollectionName != null && !this.mCollectionName.equals("")) {
            sb.append("<collection>");
            sb.append(this.replaceSpecialCharacters(this.mCollectionName));
            sb.append("</collection>\n");
        }
        sb.append("<listResources/>\n");
        sb.append("<outputStream name=\"");
        sb.append(this.getOutputs()[0].getName());
        sb.append("\"/>\n");
        sb.append("</xmlResourceManagement>\n");
        return sb.toString();
    }
}

