/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.toolkit.activity.xmldb;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import uk.org.ogsadai.client.toolkit.activity.Activity;
import uk.org.ogsadai.client.toolkit.activity.ActivityOutput;
import uk.org.ogsadai.client.toolkit.activity.NoActivityOutputException;
import uk.org.ogsadai.client.toolkit.exception.DataFormatException;
import uk.org.ogsadai.common.xml.XMLUtilities;

public class XMLListCollections
extends Activity {
    private static final String COPYRIGHT_NOTICE = "(c) University of Edinburgh 2002 - 2006.";
    private String mCollectionName = "";

    public XMLListCollections() {
        this.addOutput("ListCollectionsResult");
    }

    public void setCollectionName(String collectionName) {
        this.mCollectionName = collectionName;
    }

    public String[] getCollectionNames() throws NoActivityOutputException, DataFormatException {
        String[] collections = null;
        ActivityOutput createCollectionOutput = this.getOutputs()[0];
        String outputData = createCollectionOutput.getData();
        try {
            Document doc = XMLUtilities.xmlStringToDOM(outputData, false);
            Element elt = (Element)doc.getElementsByTagName("collectionNames").item(0);
            String countString = elt.getAttribute("count");
            int numCollections = Integer.parseInt(countString);
            NodeList kids = elt.getElementsByTagName("name");
            collections = new String[numCollections];
            for (int i = 0; i < numCollections; ++i) {
                collections[i] = kids.item(i).getFirstChild().getNodeValue();
            }
        }
        catch (Exception e) {
            throw new DataFormatException(outputData, e);
        }
        return collections;
    }

    public ActivityOutput getOutput() {
        ActivityOutput listCollectionsOutput = this.getOutputs()[0];
        return listCollectionsOutput;
    }

    protected String generateXML() {
        StringBuffer sb = new StringBuffer();
        sb.append("<xmlCollectionManagement name=\"");
        sb.append(this.getName());
        sb.append("\">\n");
        if (this.mCollectionName != null && !this.mCollectionName.equals("")) {
            sb.append("<collection>");
            sb.append(this.replaceSpecialCharacters(this.mCollectionName));
            sb.append("</collection>\n");
        }
        sb.append("<listCollections/>\n");
        sb.append("<outputStream name=\"");
        sb.append(this.getOutputs()[0].getName());
        sb.append("\"/>\n");
        sb.append("</xmlCollectionManagement>\n");
        return sb.toString();
    }
}

