/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.toolkit.activity.xmldb;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import uk.org.ogsadai.client.toolkit.activity.Activity;
import uk.org.ogsadai.client.toolkit.activity.ActivityOutput;
import uk.org.ogsadai.client.toolkit.activity.NoActivityOutputException;
import uk.org.ogsadai.client.toolkit.exception.DataFormatException;
import uk.org.ogsadai.common.xml.XMLUtilities;

public class XMLCreateResourceFromActivityOutput
extends Activity {
    private static final String COPYRIGHT_NOTICE = "(c) University of Edinburgh 2002 - 2006.";
    private String mResourceName = "";
    private String mParentCollectionName = "";

    public XMLCreateResourceFromActivityOutput() {
        this.addOutput("CreateResourceResult");
    }

    public XMLCreateResourceFromActivityOutput(String resourceName) {
        this.addInput("CreateResourceFromActivityOutputInput");
        this.addOutput("CreateResourceResult");
        this.setResourceName(resourceName);
    }

    public void setResourceName(String resourceName) {
        this.mResourceName = resourceName;
    }

    public void setParentCollectionName(String parentCollectionName) {
        this.mParentCollectionName = parentCollectionName;
    }

    public final void setInput(ActivityOutput input) {
        if (input == null) {
            throw new IllegalArgumentException("input must not be null");
        }
        super.setInput(0, input.getName());
    }

    public ActivityOutput getOutput() {
        ActivityOutput createResourceOutput = this.getOutputs()[0];
        return createResourceOutput;
    }

    public String getResourceName() throws NoActivityOutputException, DataFormatException {
        String resourceName = null;
        ActivityOutput createResourceOutput = this.getOutputs()[0];
        String outputData = createResourceOutput.getData();
        try {
            Document doc = XMLUtilities.xmlStringToDOM(outputData, false);
            Element elt = (Element)doc.getElementsByTagName("createdResource").item(0);
            resourceName = elt.getAttribute("name");
        }
        catch (Exception e) {
            throw new DataFormatException(outputData, e);
        }
        return resourceName;
    }

    protected String generateXML() {
        StringBuffer sb = new StringBuffer();
        sb.append("<xmlResourceManagement name=\"");
        sb.append(this.getName());
        sb.append("\">\n");
        if (this.mParentCollectionName != null && !this.mParentCollectionName.equals("")) {
            sb.append("<collection>");
            sb.append(this.replaceSpecialCharacters(this.mParentCollectionName));
            sb.append("</collection>\n");
        }
        sb.append("<createResource");
        if (this.mResourceName != null && !this.mResourceName.equals("")) {
            sb.append(" name =\"");
            sb.append(this.replaceSpecialCharacters(this.mResourceName));
            sb.append("\"");
        }
        sb.append(" from =\"");
        sb.append(this.replaceSpecialCharacters(this.getInputParameters()[0].getOutputName()));
        sb.append("\"");
        sb.append("/>\n");
        sb.append("<outputStream name=\"");
        sb.append(this.getOutputs()[0].getName());
        sb.append("\"/>\n");
        sb.append("</xmlResourceManagement>\n");
        return sb.toString();
    }
}

