/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.toolkit.activity.xmldb;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import uk.org.ogsadai.client.toolkit.activity.Activity;
import uk.org.ogsadai.client.toolkit.activity.ActivityOutput;
import uk.org.ogsadai.client.toolkit.activity.NoActivityOutputException;
import uk.org.ogsadai.client.toolkit.activity.xmldb.XMLDBResourceException;
import uk.org.ogsadai.client.toolkit.exception.DataFormatException;
import uk.org.ogsadai.common.xml.XMLUtilities;

public class XMLCreateResource
extends Activity {
    private static final String COPYRIGHT_NOTICE = "(c) University of Edinburgh 2002 - 2006.";
    private String mResourceName = "";
    private String mParentCollectionName = "";
    private String mContent = "";

    public XMLCreateResource() {
        this.addOutput("CreateResourceResult");
    }

    public XMLCreateResource(String content) throws XMLDBResourceException {
        this.addOutput("CreateResourceResult");
        this.setContent(content);
    }

    public void setResourceName(String resourceName) {
        this.mResourceName = resourceName;
    }

    public void setParentCollectionName(String parentCollectionName) {
        this.mParentCollectionName = parentCollectionName;
    }

    public void setContent(String content) throws XMLDBResourceException {
        if (content == null) {
            throw new IllegalArgumentException("content must not be null");
        }
        try {
            XMLUtilities.xmlStringToDOM(content, false);
        }
        catch (Exception e) {
            throw new XMLDBResourceException(e);
        }
        this.mContent = content;
    }

    public void setContentFromFile(String contentFileName) throws XMLDBResourceException {
        if (contentFileName == null) {
            throw new IllegalArgumentException("contentFileName must not be null");
        }
        try {
            this.mContent = XMLUtilities.xmlDOMToString(XMLUtilities.xmlFileToDOM(contentFileName, false));
        }
        catch (Exception e) {
            throw new XMLDBResourceException(e);
        }
    }

    public ActivityOutput getOutput() {
        ActivityOutput createResourceOutput = this.getOutputs()[0];
        return createResourceOutput;
    }

    public String getResourceName() throws NoActivityOutputException, DataFormatException {
        String resourceName = null;
        ActivityOutput createResourceOutput = this.getOutputs()[0];
        String outputData = createResourceOutput.getData();
        try {
            Document doc = XMLUtilities.xmlStringToDOM(outputData, false);
            Element elt = (Element)doc.getElementsByTagName("createdResource").item(0);
            resourceName = elt.getAttribute("name");
        }
        catch (Exception e) {
            throw new DataFormatException(outputData, e);
        }
        return resourceName;
    }

    protected String generateXML() {
        StringBuffer sb = new StringBuffer();
        sb.append("<xmlResourceManagement name=\"");
        sb.append(this.getName());
        sb.append("\">\n");
        if (this.mParentCollectionName != null && !this.mParentCollectionName.equals("")) {
            sb.append("<collection>");
            sb.append(this.replaceSpecialCharacters(this.mParentCollectionName));
            sb.append("</collection>\n");
        }
        sb.append("<createResource");
        if (this.mResourceName != null && !this.mResourceName.equals("")) {
            sb.append(" name =\"");
            sb.append(this.replaceSpecialCharacters(this.mResourceName));
            sb.append("\"");
        }
        sb.append(">\n");
        sb.append(this.mContent);
        sb.append("\n</createResource>\n");
        sb.append("<outputStream name=\"");
        sb.append(this.getOutputs()[0].getName());
        sb.append("\"/>\n");
        sb.append("</xmlResourceManagement>\n");
        return sb.toString();
    }
}

