/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.toolkit.activity.xmldb;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xmldb.api.base.ResourceSet;
import uk.org.ogsadai.client.toolkit.activity.Activity;
import uk.org.ogsadai.client.toolkit.activity.ActivityInputParameterInternal;
import uk.org.ogsadai.client.toolkit.activity.ActivityOutput;
import uk.org.ogsadai.client.toolkit.activity.NoActivityOutputException;
import uk.org.ogsadai.client.toolkit.activity.xmldb.XMLDBResourceException;
import uk.org.ogsadai.client.toolkit.activity.xmldb.XMLResourceSetBlockMaker;
import uk.org.ogsadai.client.toolkit.exception.DataFormatException;
import uk.org.ogsadai.common.xml.XMLUtilities;

public class XMLBulkLoad
extends Activity {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2006. (c) University of Edinburgh 2002 - 2006.";
    private String mCollectionName = "";
    private boolean mCreateIfNotExists = false;
    private String mData;

    public XMLBulkLoad() {
        ActivityInputParameterInternal param = this.addInput("XMLBulkLoadInput");
        param.setIsOptional(true);
        this.addOutput("XMLBulkLoadResult");
    }

    public XMLBulkLoad(ActivityOutput input) {
        this();
        this.setInput(input);
    }

    public final void setInput(ActivityOutput input) {
        if (input == null) {
            throw new IllegalArgumentException("input must not be null");
        }
        super.setInput(0, input.getName());
    }

    public void setInputData(ResourceSet resources) throws XMLDBResourceException {
        if (resources == null) {
            this.mData = null;
            return;
        }
        try {
            XMLResourceSetBlockMaker blocks = new XMLResourceSetBlockMaker(resources);
            StringBuffer data = new StringBuffer();
            while (blocks.hasNext()) {
                data.append((String)blocks.next());
            }
            this.mData = data.toString();
        }
        catch (Exception e) {
            throw new XMLDBResourceException(e);
        }
    }

    public void setInputData(String content) throws XMLDBResourceException {
        if (content != null) {
            try {
                XMLUtilities.xmlStringToDOM(content, false);
            }
            catch (Exception e) {
                throw new XMLDBResourceException(e);
            }
        }
        this.mData = content;
    }

    public void setInputData(Document document) {
        this.mData = document == null ? null : XMLUtilities.xmlDOMToString(document);
    }

    public void setCollectionName(String collectionName) {
        this.setCollectionName(collectionName, false);
    }

    public void setCollectionName(String collectionName, boolean createIfNotExists) {
        this.mCollectionName = collectionName;
        this.mCreateIfNotExists = createIfNotExists;
    }

    public int getResultCount() throws NoActivityOutputException, DataFormatException {
        ActivityOutput createResourceOutput = this.getOutputs()[0];
        String outputData = createResourceOutput.getData();
        int numResources = 0;
        try {
            Document doc = XMLUtilities.xmlStringToDOM(outputData, false);
            Element elt = (Element)doc.getElementsByTagName("resultCount").item(0);
            numResources = Integer.parseInt(elt.getFirstChild().getNodeValue());
        }
        catch (Exception e) {
            throw new DataFormatException(outputData, e);
        }
        return numResources;
    }

    public ActivityOutput getOutput() {
        return this.getOutputs()[0];
    }

    protected String generateXML() {
        StringBuffer sb = new StringBuffer();
        sb.append("<xmlBulkLoad name=\"");
        sb.append(this.getName());
        sb.append("\">\n");
        if (this.mCollectionName != null && !this.mCollectionName.equals("")) {
            sb.append("<collection createIfNotExists=\"");
            sb.append(this.mCreateIfNotExists);
            sb.append("\">");
            sb.append(this.replaceSpecialCharacters(this.mCollectionName));
            sb.append("</collection>\n");
        }
        if (this.mData != null) {
            sb.append(this.mData);
            sb.append("\n");
        } else {
            sb.append("<fromLocal from=\"");
            sb.append(this.replaceSpecialCharacters(this.getInputParameters()[0].getOutputName()));
            sb.append("\"/>\n");
        }
        sb.append("<output name=\"");
        sb.append(this.getOutputs()[0].getName());
        sb.append("\"/>\n");
        sb.append("</xmlBulkLoad>\n");
        return sb.toString();
    }
}

