/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.toolkit.activity.transform;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import uk.org.ogsadai.client.toolkit.activity.Activity;
import uk.org.ogsadai.client.toolkit.activity.ActivityOutput;
import uk.org.ogsadai.client.toolkit.activity.NoActivityOutputException;
import uk.org.ogsadai.client.toolkit.activity.transform.ZIPChecksum;
import uk.org.ogsadai.client.toolkit.exception.DataFormatException;
import uk.org.ogsadai.common.xml.XMLUtilities;

public class ZIPArchive
extends Activity {
    private static final String COPYRIGHT_NOTICE = "(c) University of Edinburgh 2002 - 2006";
    private static final int ARCHIVED_OUTPUT_INDEX = 0;
    private static final int META_DATA_OUTPUT_INDEX = 1;
    private static final String INPUT_NAME = "zipArchiveInput";
    private String mComment;
    private ZIPChecksum mChecksumType;
    private int mLevel;

    public ZIPArchive() {
        this.addOutput("zipArchiveOutputArchived");
        this.addOutput("zipArchiveOutputMetaData");
    }

    public void setChecksumType(ZIPChecksum checksumType) {
        if (checksumType == null) {
            throw new IllegalArgumentException("checksumType must not be null");
        }
        this.mChecksumType = checksumType;
    }

    public void setComment(String comment) {
        if (comment == null) {
            throw new IllegalArgumentException("comment must not benull");
        }
        if (comment.getBytes().length > 65535) {
            throw new IllegalArgumentException("comment must not be longer than 0xFFFF : " + comment.getBytes().length);
        }
        this.mComment = comment;
    }

    public void setLevel(int level) {
        if (level < 0 || level > 9) {
            throw new IllegalArgumentException("level must be >= 0 and <= 9 : " + level);
        }
        this.mLevel = level;
    }

    public void addEntry(ActivityOutput input) {
        if (input == null) {
            throw new IllegalArgumentException("input must not be null");
        }
        int index = super.getInputParameters().length;
        super.addInput(INPUT_NAME + index);
        super.setInput(index, input.getName());
    }

    public ActivityOutput getArchivedDataOutput() {
        return this.getOutputs()[0];
    }

    public ActivityOutput getMetaDataOutput() {
        return this.getOutputs()[1];
    }

    public long getChecksumValue() throws NoActivityOutputException, DataFormatException {
        long checksum = 0L;
        ActivityOutput output = this.getMetaDataOutput();
        try {
            Document doc = XMLUtilities.xmlStringToDOM(output.getData(), false);
            Element elt = (Element)doc.getElementsByTagName("checksum").item(0);
            String checksumString = elt.getAttribute("value");
            checksum = Long.valueOf(checksumString);
        }
        catch (Exception e) {
            String outputData = output.getData();
            throw new DataFormatException("java.lang.Long", outputData, e);
        }
        return checksum;
    }

    public String getChecksumType() throws NoActivityOutputException, DataFormatException {
        String checksumType = null;
        ActivityOutput output = this.getMetaDataOutput();
        try {
            Document doc = XMLUtilities.xmlStringToDOM(output.getData(), false);
            Element elt = (Element)doc.getElementsByTagName("checksum").item(0);
            checksumType = elt.getAttribute("type");
        }
        catch (Exception e) {
            String outputData = output.getData();
            throw new DataFormatException(outputData, e);
        }
        return checksumType;
    }

    protected String generateXML() {
        StringBuffer sb = new StringBuffer();
        sb.append("<zipArchive name=\"");
        sb.append(this.getName());
        sb.append("\">\n");
        if (this.mComment != null) {
            sb.append("<comment>");
            sb.append(this.replaceSpecialCharacters(this.mComment));
            sb.append("</comment>\n");
        }
        sb.append("<settings ");
        sb.append("checksum=\"");
        sb.append(this.mChecksumType.getAsString());
        sb.append("\" ");
        sb.append("level=\"");
        sb.append(this.mLevel);
        sb.append("\"/>\n");
        int numInputs = this.getInputParameters().length;
        for (int i = 0; i < numInputs; ++i) {
            sb.append("<zipEntry from=\"");
            sb.append(this.replaceSpecialCharacters(this.getInputParameters()[i].getOutputName()));
            sb.append("\"/>\n");
        }
        sb.append("<archivedOutput name=\"");
        sb.append(this.getOutputs()[0].getName());
        sb.append("\"/>\n");
        sb.append("<metadataOutput name=\"");
        sb.append(this.getOutputs()[1].getName());
        sb.append("\"/>\n");
        sb.append("</zipArchive>");
        return sb.toString();
    }
}

