/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.toolkit.activity.transform;

import org.w3c.dom.Document;
import uk.org.ogsadai.client.toolkit.activity.Activity;
import uk.org.ogsadai.client.toolkit.activity.ActivityOutput;
import uk.org.ogsadai.common.xml.XMLUtilities;

public class XSLTransform
extends Activity {
    private static final String COPYRIGHT_NOTICE = "(c) University of Edinburgh 2002 - 2006.";
    private static final int XML_INPUT_INDEX = 0;
    private static final int XSLT_INPUT_INDEX = 1;
    private String mXSLTInput = null;

    public XSLTransform() {
        this.addInput("xslTransformXMLInput");
        this.addInput("xslTransformXSLTInput");
        this.addOutput("xslTransformOutput");
    }

    public void setXMLInput(ActivityOutput input) {
        if (input == null) {
            throw new IllegalArgumentException("input must not be null");
        }
        super.setInput(0, input.getName());
    }

    public void setXSLTInput(ActivityOutput input) {
        if (input == null) {
            throw new IllegalArgumentException("input must not be null");
        }
        this.mXSLTInput = null;
        super.setInput(1, input.getName());
    }

    public void setXSLTInput(Document input) {
        if (input == null) {
            throw new IllegalArgumentException("input must not be null");
        }
        String inpStr = XMLUtilities.xmlDOMToString(input);
        if (!inpStr.startsWith("<?xml")) {
            throw new IllegalArgumentException("input must be an XML document");
        }
        int end = inpStr.indexOf(62);
        this.mXSLTInput = inpStr.substring(end + 1);
    }

    public void setXSLTInput(String input) {
        if (input == null) {
            throw new IllegalArgumentException("input must not be null");
        }
        if (input.trim().equals("")) {
            throw new IllegalArgumentException("input must not be ''");
        }
        if (input.startsWith("<?xml")) {
            int end = input.indexOf(62);
            this.mXSLTInput = input.substring(end + 1);
        } else {
            this.mXSLTInput = input.intern();
        }
    }

    public ActivityOutput getOutput() {
        return this.getOutputs()[0];
    }

    protected String generateXML() {
        StringBuffer sb = new StringBuffer();
        sb.append("<xslTransform name=\"");
        sb.append(this.getName());
        sb.append("\">\n");
        if (this.mXSLTInput == null) {
            sb.append("<inputXSLT from=\"");
            sb.append(this.getInputParameters()[1].getOutputName());
            sb.append("\"/>\n");
        } else {
            sb.append("<inputXSLT>\n");
            sb.append(this.mXSLTInput);
            sb.append("\n</inputXSLT>\n");
        }
        sb.append("<inputXML from=\"");
        sb.append(this.getInputParameters()[0].getOutputName());
        sb.append("\"/>");
        sb.append("<output name=\"");
        sb.append(this.getOutputs()[0].getName());
        sb.append("\"/>");
        sb.append("</xslTransform>");
        return sb.toString();
    }
}

