/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.toolkit.activity.transform;

import uk.org.ogsadai.client.toolkit.activity.Activity;
import uk.org.ogsadai.client.toolkit.activity.ActivityOutput;

public class WebRowSetProjection
extends Activity {
    private static final String COPYRIGHT_NOTICE = "(c) University of Edinburgh 2002 - 2006";
    private String mColumnName;
    private int mColumnIndex;

    public WebRowSetProjection(ActivityOutput input, String columnName) {
        if (columnName == null) {
            throw new IllegalArgumentException("columnName must not be null");
        }
        this.addInput("Webrowset Input");
        this.addOutput("Column projection Output");
        this.mColumnName = columnName;
        this.setInput(input);
    }

    public WebRowSetProjection(ActivityOutput input, int columnIndex) {
        if (columnIndex <= 0) {
            throw new IllegalArgumentException("columnIndex must be > 0 : " + columnIndex);
        }
        this.addInput("Webrowset Input");
        this.addOutput("Column projection Output");
        this.mColumnIndex = columnIndex;
        this.setInput(input);
    }

    public final void setInput(ActivityOutput input) {
        if (input == null) {
            throw new IllegalArgumentException("input must not be null");
        }
        super.setInput(0, input.getName());
    }

    public ActivityOutput getOutput() {
        return this.getOutputs()[0];
    }

    protected String generateXML() {
        StringBuffer xml = new StringBuffer();
        xml.append("<webRowSetProjection name=\"");
        xml.append(this.getName());
        xml.append("\">\n");
        xml.append("<webRowSetInput from=\"");
        xml.append(this.getInputParameters()[0].getOutputName());
        xml.append("\"/>\n");
        if (this.mColumnName != null) {
            xml.append("  <attributeName>");
            xml.append(this.mColumnName);
            xml.append("</attributeName>");
        } else {
            xml.append("  <attributeIndex>");
            xml.append(this.mColumnIndex);
            xml.append("</attributeIndex>\n");
        }
        xml.append("  <attributeValuesOutput name=\"");
        xml.append(this.getOutputs()[0].getName());
        xml.append("\"/>\n");
        xml.append("</webRowSetProjection>");
        return xml.toString();
    }
}

