/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.toolkit.activity.transform;

import uk.org.ogsadai.client.toolkit.activity.Activity;
import uk.org.ogsadai.client.toolkit.activity.ActivityOutput;

public class RandomSample
extends Activity {
    private static final String COPYRIGHT_NOTICE = "(c) University of Edinburgh 2002 - 2006";
    private double mFraction;
    private long mSeed;
    private boolean mIs_seed = false;

    public RandomSample(ActivityOutput input, double fraction) {
        this.addInput("Sequence of values as input");
        this.addOutput("Sequence of values as output");
        this.mFraction = fraction;
        this.setInput(input);
    }

    public RandomSample(ActivityOutput input, double fraction, long seed) {
        this.addInput("Sequence of values as input");
        this.addOutput("Sequence of values as output");
        this.mFraction = fraction;
        this.mIs_seed = true;
        this.mSeed = seed;
        this.setInput(input);
    }

    public final void setInput(ActivityOutput input) {
        if (input == null) {
            throw new IllegalArgumentException("input must not be null");
        }
        super.setInput(0, input.getName());
    }

    public ActivityOutput getOutput() {
        return this.getOutputs()[0];
    }

    protected String generateXML() {
        StringBuffer xml = new StringBuffer();
        xml.append("<randomSample name=\"");
        xml.append(this.getName());
        xml.append("\">\n");
        xml.append("<inputValues from=\"");
        xml.append(this.getInputParameters()[0].getOutputName());
        xml.append("\"/>\n");
        xml.append("  <fraction>");
        xml.append(this.mFraction);
        xml.append("</fraction>\n");
        if (this.mIs_seed) {
            xml.append("  <seed>");
            xml.append(this.mSeed);
            xml.append("</seed>\n");
        }
        xml.append("  <sampleOutput name=\"");
        xml.append(this.getOutputs()[0].getName());
        xml.append("\"/>\n");
        xml.append("</randomSample>");
        return xml.toString();
    }
}

