/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.toolkit.activity.transform;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import uk.org.ogsadai.client.toolkit.activity.Activity;
import uk.org.ogsadai.client.toolkit.activity.ActivityOutput;
import uk.org.ogsadai.client.toolkit.activity.NoActivityOutputException;
import uk.org.ogsadai.client.toolkit.activity.transform.ZIPChecksum;
import uk.org.ogsadai.client.toolkit.exception.DataFormatException;
import uk.org.ogsadai.common.xml.XMLUtilities;

public class GZIPDecompression
extends Activity {
    private static final String COPYRIGHT_NOTICE = "(c) University of Edinburgh 2002 - 2006";
    private static final int DECOMPRESSED_OUTPUT_INDEX = 0;
    private static final int META_DATA_OUTPUT_INDEX = 1;
    private ZIPChecksum mChecksumType = ZIPChecksum.ADLER;

    public GZIPDecompression() {
        this.addInput("gzipDecompressionInput");
        this.addOutput("gzipDecompressionOutput");
        this.addOutput("gzipDecompressionOutputMetaData");
    }

    public void setChecksumType(ZIPChecksum checksumType) {
        if (checksumType == null) {
            throw new IllegalArgumentException("checksumType must not be null");
        }
        this.mChecksumType = checksumType;
    }

    public final void setInput(ActivityOutput input) {
        if (input == null) {
            throw new IllegalArgumentException("input must not be null");
        }
        super.setInput(0, input.getName());
    }

    public ActivityOutput getDecompressedDataOutput() {
        return this.getOutputs()[0];
    }

    public ActivityOutput getMetaDataOutput() {
        return this.getOutputs()[1];
    }

    public long getChecksumValue() throws NoActivityOutputException, DataFormatException {
        long checksum = 0L;
        ActivityOutput output = this.getMetaDataOutput();
        try {
            Document doc = XMLUtilities.xmlStringToDOM(output.getData(), false);
            Element elt = (Element)doc.getElementsByTagName("checksum").item(0);
            String checksumString = elt.getAttribute("value");
            checksum = Long.valueOf(checksumString);
        }
        catch (Exception e) {
            String outputData = output.getData();
            throw new DataFormatException("java.lang.Long", outputData, e);
        }
        return checksum;
    }

    public String getChecksumType() throws NoActivityOutputException, DataFormatException {
        String checksumType = null;
        ActivityOutput output = this.getMetaDataOutput();
        try {
            Document doc = XMLUtilities.xmlStringToDOM(output.getData(), false);
            Element elt = (Element)doc.getElementsByTagName("checksum").item(0);
            checksumType = elt.getAttribute("type");
        }
        catch (Exception e) {
            String outputData = output.getData();
            throw new DataFormatException(outputData, e);
        }
        return checksumType;
    }

    protected String generateXML() {
        StringBuffer sb = new StringBuffer();
        sb.append("<gzipDecompression name=\"");
        sb.append(this.getName());
        sb.append("\">\n");
        sb.append("<settings");
        sb.append(" checksum=\"");
        sb.append(this.mChecksumType);
        sb.append("\"");
        sb.append("/>\n");
        sb.append("<input from=\"");
        sb.append(this.replaceSpecialCharacters(this.getInputParameters()[0].getOutputName()));
        sb.append("\"/>\n");
        sb.append("<decompressedOutput name=\"");
        sb.append(this.getOutputs()[0].getName());
        sb.append("\"/>\n");
        sb.append("<metadataOutput name=\"");
        sb.append(this.getOutputs()[1].getName());
        sb.append("\"/>\n");
        sb.append("</gzipDecompression>");
        return sb.toString();
    }
}

